FROM nvidia/cuda:11.0.3-cudnn8-runtime-ubuntu20.04

# Basic env variables
ENV PATH=/usr/local/bin:$PATH \
	LANG=C.UTF-8 \
	GPG_KEY=E3FF2839C048B25C084DEBE9B26995E310250568

# Install build dependencies
RUN apt-get update \
	&& DEBIAN_FRONTEND=noninteractive \
	apt-get install -y --no-install-recommends \
	autoconf automake build-essential bzip2 dpkg-dev file g++ gcc git imagemagick \
	libbluetooth-dev libbz2-dev libc6-dev libcurl4-openssl-dev libdb-dev libevent-dev \
	libffi-dev libgdbm-dev libglib2.0-dev libgmp-dev libjpeg-dev libkrb5-dev liblzma-dev \
	libmagickcore-dev libmagickwand-dev libmaxminddb-dev libncurses5-dev libncursesw5-dev \
	libnss3-dev libpng-dev libpq-dev libreadline-dev libsqlite3-dev libssl-dev libtool \
	libwebp-dev libxml2-dev libxslt-dev libyaml-dev make patch tk-dev unzip uuid-dev wget \
	xz-utils zlib1g-dev \
	&& rm -rf /var/lib/apt/lists/*

# Install python
ARG PYTHON_VERSION
RUN set -ex \
	&& wget -O python.tar.xz "https://www.python.org/ftp/python/${PYTHON_VERSION%%[a-z]*}/Python-$PYTHON_VERSION.tar.xz" \
	&& wget -O python.tar.xz.asc "https://www.python.org/ftp/python/${PYTHON_VERSION%%[a-z]*}/Python-$PYTHON_VERSION.tar.xz.asc" \
	&& export GNUPGHOME="$(mktemp -d)" \
	&& gpg --batch --keyserver hkps://keys.openpgp.org --recv-keys "$GPG_KEY" \
	&& gpg --batch --verify python.tar.xz.asc python.tar.xz \
	&& { command -v gpgconf > /dev/null && gpgconf --kill all || :; } \
	&& rm -rf "$GNUPGHOME" python.tar.xz.asc \
	&& mkdir -p /usr/src/python \
	&& tar -xJC /usr/src/python --strip-components=1 -f python.tar.xz \
	&& rm python.tar.xz \
	&& cd /usr/src/python \
	&& gnuArch="$(dpkg-architecture --query DEB_BUILD_GNU_TYPE)" \
	&& ./configure \
	--build="$gnuArch" \
	--enable-loadable-sqlite-extensions \
	--enable-optimizations \
	--enable-option-checking=fatal \
	--enable-shared \
	--with-system-expat \
	--with-system-ffi \
	--without-ensurepip \
	&& make -j "$(nproc)" \
	&& make install \
	&& rm -rf /usr/src/python \
	&& find /usr/local -depth \
	\( \
	\( -type d -a \( -name test -o -name tests -o -name idle_test \) \) \
	-o \( -type f -a \( -name '*.pyc' -o -name '*.pyo' -o -name '*.a' \) \) \
	-o \( -type f -a -name 'wininst-*.exe' \) \
	\) -exec rm -rf '{}' + \
	&& ldconfig \
	&& python3 --version

# Create symlinks
RUN cd /usr/local/bin \
	&& ln -s idle3 idle \
	&& ln -s pydoc3 pydoc \
	&& ln -s python3 python \
	&& ln -s python3-config python-config

# Install pip
ENV PYTHON_PIP_VERSION 21.2.3
ENV PYTHON_GET_PIP_URL https://github.com/pypa/get-pip/raw/c20b0cfd643cd4a19246ccf204e2997af70f6b21/public/get-pip.py
ENV PYTHON_GET_PIP_SHA256 fa6f3fb93cce234cd4e8dd2beb54a51ab9c247653b52855a48dd44e6b21ff28b

RUN set -ex; \
	wget -O get-pip.py "$PYTHON_GET_PIP_URL"; \
	echo "$PYTHON_GET_PIP_SHA256 *get-pip.py" | sha256sum --check --strict -; \
	python get-pip.py \
	--disable-pip-version-check \
	--no-cache-dir \
	"pip==$PYTHON_PIP_VERSION" \
	; \
	pip --version; \
	find /usr/local -depth \
	\( \
	\( -type d -a \( -name test -o -name tests -o -name idle_test \) \) \
	-o \
	\( -type f -a \( -name '*.pyc' -o -name '*.pyo' \) \) \
	\) -exec rm -rf '{}' +; \
	rm -f get-pip.py

# Install R
RUN apt-get update \
	&& apt-get install -y r-base \
	&& R -e 'install.packages(c("forecast", "nnfor"), repos="https://cloud.r-project.org")'

# Install project dependencies
RUN pip install poetry==1.1.6 \
	&& poetry config virtualenvs.create false
COPY poetry.lock pyproject.toml /dependencies/
RUN cd /dependencies \
	&& poetry install --no-dev --no-root --no-interaction --no-ansi
