#!/bin/bash
set -o errexit

echo "Fetching credentials from AWS..."
AWS_ACCOUNT=$(aws sts get-caller-identity --query Account --output text)
AWS_REGION=$(aws configure get region)
ECR_PASSWORD=$(aws ecr get-login-password)
REGISTRY=$AWS_ACCOUNT.dkr.ecr.$AWS_REGION.amazonaws.com

echo "Logging in to ECR..."
echo $ECR_PASSWORD | \
    docker login --username AWS --password-stdin $REGISTRY

echo "Building image..."
docker build \
    --build-arg PYTHON_VERSION=$(cat .python-version | tr -d '\n') \
    -t $REGISTRY/ts-bench:gpu-latest \
    -f build/docker/gpu.Dockerfile .
docker build \
    --build-arg PYTHON_VERSION=$(cat .python-version | tr -d '\n') \
    -t $REGISTRY/ts-bench:cpu-latest \
    -f build/docker/cpu.Dockerfile .

echo "Pushing image..."
docker push $REGISTRY/ts-bench:gpu-latest
docker push $REGISTRY/ts-bench:cpu-latest
