import click
from tqdm.auto import tqdm
from tsbench.config import DATASET_REGISTRY


@click.command()
def main():
    """
    Downloads and preprocesses all datasets that are potentially used for training.
    """
    with tqdm(total=len(DATASET_REGISTRY)) as progress:
        for name, config in DATASET_REGISTRY.items():
            progress.set_postfix({"dataset": name})
            config.generate()
            config.prepare()
            progress.update()


if __name__ == "__main__":
    main()
