import click
from tqdm.auto import tqdm
from tqdm.contrib.concurrent import thread_map
from tsbench.experiments.aws import Analysis, TrainingJob


@click.command()
@click.option("--experiment", type=str, default="ts-bench")
def main(experiment: str):
    """
    Pulls the data from all training runs associated with the provided experiment.
    """
    analysis = Analysis(experiment)

    def pull_artifact(job: TrainingJob):
        with job.artifact:
            pass

    # Pull all artifacts
    thread_map(pull_artifact, analysis, desc="pulling artifacts", ascii=True)

    # Pull all logs
    for job in tqdm(analysis, desc="pulling logs", ascii=True):
        job.pull_logs()


if __name__ == "__main__":
    # pylint: disable=no-value-for-parameter
    main()
