import click
from tqdm.auto import tqdm
from tsbench.config import DATASET_REGISTRY
from tsbench.experiments.aws import default_session
from tsbench.experiments.aws.s3 import upload_directory


@click.command()
@click.option("--bucket", type=str, default="ts-bench")
def main(bucket: str):
    """
    Uploads the data for all datasets in the registry to an S3 bucket.
    """
    s3 = default_session().client("s3")

    # Run processing for all datasets
    for config in tqdm(DATASET_REGISTRY.values()):
        upload_directory(s3, config.root.as_posix(), bucket, f"data/{config.name}")


if __name__ == "__main__":
    # pylint: disable=no-value-for-parameter
    main()
