import subprocess
from pathlib import Path
from typing import Any


def run_sacred_script(script: str, **kwargs: Any) -> None:
    """
    Runs the Sacred script with the provided name in a subprocess, passing the provided parameters.

    Args:
        script: The name of the script in `cli/sacred`.
        kwargs: Parameters to pass to the script.
    """
    subprocess.call(
        [
            "python",
            "-W",
            "ignore",
            (Path(__file__).parent.parent / "sacred" / script).as_posix(),
            "-m",
            "localhost:27017:sacred",
            "with",
        ]
        + [f"{k}={_sacred_value(v)}" for k, v in kwargs.items()]
    )


def _sacred_value(value: str) -> str:
    return f'"{value}"' if isinstance(value, str) else f"{value}"
