from .base import DatasetConfig
from .registry import DATASET_REGISTRY


def get_dataset_config(name: str) -> DatasetConfig:
    """
    This method creates the dataset configuration of the model with the specified name.

    Args:
        name: The canonical name of the dataset. See `DATASET_REGISTRY`.

    Returns:
        The dataset configuration.
    """
    # Get the dataset
    assert name in DATASET_REGISTRY, f"Dataset name '{name}' is unknown."
    return DATASET_REGISTRY[name]
