from typing import Dict, Type, TypeVar
from .base import DatasetConfig

DATASET_REGISTRY: Dict[str, DatasetConfig] = {}


D = TypeVar("D", bound=Type[DatasetConfig])


def register_dataset(cls: D) -> D:
    """
    Registers the provided class in the global dataset registry.
    """
    instance = cls()
    DATASET_REGISTRY[instance.name] = instance
    return cls
