from typing import Dict, Type, TypeVar
from .base import ModelConfig

MODEL_REGISTRY: Dict[str, ModelConfig] = {}


M = TypeVar("M", bound=Type[ModelConfig])


def register_model(cls: M) -> M:
    """
    Registers the provided class in the global model registry.
    """
    MODEL_REGISTRY[cls.name()] = cls
    return cls
