import numpy as np
import pygmo


def hypervolume(points: np.ndarray, box: float = 1) -> float:
    """
    Computes the hypervolume assuming that all values were previously normalized to lie in the
    range (0, 1).

    Args:
        point: Array of shape [N, D] (N: number of points, D: dimensionality) containing the points
            of the Pareto front.
        box: The coordinate of the box's edge. By default, this is located at [1, ..., 1] with
            the appropriate dimensionality.

    Returns:
        The hypervolume.
    """
    dim = points.shape[1]
    ref = np.ones(dim) * box
    return pygmo.hypervolume(points).compute(ref) / (box ** dim)
