from dataclasses import dataclass
from typing import List
import pandas as pd
from tsbench.config import Config
from tsbench.experiments.metrics import Performance


@dataclass
class ExperimentResults:
    """
    The experiment results provide the configurations and collected performance metrics from a set
    of experiments.
    """

    configurations: List[Config]
    performances: List[Performance]

    def dataframe(self, std: bool = True) -> pd.DataFrame:
        """
        Returns a dataframe which contains the performance metrics as columns and the
        configurations as multi-index.

        Args:
            std: Whether to include the standard deviation of performance metrics in the dataframe.
        """
        index_df = Config.to_dataframe(self.configurations, lambda d: {"": d.name})
        # Reorder columns
        column_order = ["dataset"] + [c for c in index_df.columns.tolist() if c != "dataset"]
        index = pd.MultiIndex.from_frame(index_df[column_order])
        df = Performance.to_dataframe(self.performances, std=std)
        df.index = index
        return df.sort_index()
