from typing import Any
from .base import Recommender
from .registry import RECOMMENDER_REGISTRY


def create_recommender(name: str, **kwargs: Any) -> Recommender:
    """
    Creates a recommender using the specified parameters.
    """
    assert name in RECOMMENDER_REGISTRY, f"Unknown recommender {name}."
    recommender_cls = RECOMMENDER_REGISTRY[name]
    return recommender_cls(**kwargs)
