from abc import ABC, abstractmethod
from typing import List, Optional
from tsbench.config import ModelConfig


class CandidateGenerator(ABC):
    """
    A candidate generator provides candidate model configurations to the recommender.
    """

    @abstractmethod
    def fit(self, configs: List[ModelConfig]) -> None:
        """
        Fits the candidate generator on a list of model configurations seen during training.

        Args:
            configs: The model configurations seen during training.
        """

    @abstractmethod
    def generate(self, candidates: Optional[List[ModelConfig]] = None) -> List[ModelConfig]:
        """
        Generates a list of possible model configurations according to the strategy defined by the
        class.

        Args:
            candidates: If provided, every model configuration returned must be a member of this
                set.

        Returns:
            The generated model configurations.
        """
