from typing import List, Optional
from tsbench.config import ModelConfig
from .base import CandidateGenerator


class ReplayCandidateGenerator(CandidateGenerator):
    """
    The replay candidate generator simply returns the model configurations seen during training. If
    candidates are provided, they are returned as is.
    """

    def __init__(self) -> None:
        """
        Initializes a new replay candidate generator.
        """
        self.cache: List[ModelConfig] = []

    def fit(self, configs: List[ModelConfig]) -> None:
        self.cache = configs

    def generate(self, candidates: Optional[List[ModelConfig]] = None) -> List[ModelConfig]:
        # Assert trained
        assert self.cache, "Replay candidate generator has not been fitted."

        # Return candidates or cache
        return candidates or self.cache
