from typing import Callable, Dict, Type, TypeVar
from .base import Recommender

RECOMMENDER_REGISTRY: Dict[str, Type[Recommender]] = {}


R = TypeVar("R", bound=Type[Recommender])


def register_recommender(name: str) -> Callable[[R], R]:
    """
    Registers the provided class with the given name in the global recommender registry.
    """

    def register(cls: R) -> R:
        RECOMMENDER_REGISTRY[name] = cls
        return cls

    return register
