from .base import Surrogate
from .factory import create_surrogate
from .mlp import MLPSurrogate
from .nonparametric import NonparametricSurrogate
from .random import RandomSurrogate
from .registry import SURROGATE_REGISTRY
from .xgboost import XGBoostSurrogate

__all__ = [
    "Surrogate",
    "create_surrogate",
    "MLPSurrogate",
    "NonparametricSurrogate",
    "RandomSurrogate",
    "SURROGATE_REGISTRY",
    "XGBoostSurrogate",
]

# We need to set some parallelism flags to ensure that PyTorch behaves well on beastier machines
import torch  # pylint: disable=wrong-import-order

torch.set_num_threads(4)
torch.set_num_interop_threads(4)
