from typing import Callable, Dict, Type, TypeVar
from .base import Surrogate

SURROGATE_REGISTRY: Dict[str, Type[Surrogate]] = {}


S = TypeVar("S", bound=Type[Surrogate])


def register_surrogate(name: str) -> Callable[[S], S]:
    """
    Registers the provided class with the given name in the global surrogate registry.
    """

    def register(cls: S) -> S:
        SURROGATE_REGISTRY[name] = cls
        return cls

    return register
