import matplotlib.pyplot as plt
import pandas as pd
from gluonts.model.forecast import QuantileForecast


def plot_forecast(forecast: QuantileForecast) -> None:
    """
    Plots the provided forecast with confidence intervals using all provided quantiles.
    """
    assert len(forecast.forecast_keys) % 2 == 1, "Forecast must provide an odd number of quantiles"

    length = forecast.forecast_array.shape[1]
    index = pd.date_range(start=forecast.start_date, periods=length, freq=forecast.freq)

    # Matplotlib setup
    cmap = plt.get_cmap("Blues")

    # Plot the shapes for the confidence intervals, starting with the outermost
    num_intervals = len(forecast.forecast_keys) // 2
    for i in range(num_intervals):
        lower = forecast.forecast_array[i]
        upper = forecast.forecast_array[-(i + 1)]
        ci = 100 - 2 * int(float(forecast.forecast_keys[i]) * 100)
        cmap_index = int((cmap.N / (num_intervals + 1)) * (i + 1))
        plt.fill_between(index, lower, upper, color=cmap(cmap_index), label=f"{ci}% CI")

    # Plot the mean as line
    series = pd.Series(forecast.mean, index=index)
    plt.plot(series, c=cmap.get_over(), label="Median")
