import math
from typing import List, Optional
import matplotlib.pyplot as plt
import numpy as np


def plot_feature_histograms(features: np.ndarray, titles: Optional[List[str]] = None) -> None:
    """
    Plots histograms of the features provided via the given array.
    """
    n_rows = math.ceil(features.shape[1] / 4)
    _, axes = plt.subplots(n_rows, 4, figsize=[16, 3 * n_rows], dpi=150)
    for i in range(n_rows * 4):
        axis = axes[i // 4, i % 4]
        if i < features.shape[1]:
            if titles is not None:
                axis.set_title(titles[i])
            axis.hist(features[:, i], bins=25, density=True)
            axis.set_yticks([])
        else:
            axis.axis("off")
    plt.tight_layout()
