import torch
import random
from torch.utils.data import Dataset, DataLoader
from PIL import Image
from IPython import embed
from tqdm import tqdm

from skimage.feature import greycomatrix


class DeepFakeDatasetPathList(Dataset):
    def __init__(self, real_imgs, fake_imgs, transform=None):

        self.transform = transform
        self.imgs = real_imgs + fake_imgs
        random.shuffle(self.imgs)
        self.images = []
        for a,b in tqdm(self.imgs, desc="Loading images"):
            self.images.append((self.transform(Image.open(a)), b))
        self.imgs = self.images

    def __len__(self):
        return len(self.imgs)

    def __getitem__(self, idx):
        #image = Image.open(self.imgs[idx][0])
        image = self.imgs[idx][0]
        label = self.imgs[idx][1]
        # if self.transform:
        #     sample = (self.transform(image), label)
        #     if sample[0].size()[0] == 1:
        #         sample = (self.transform(image).repeat(3,1,1), label)
        # else:
        sample = (image, label)
        return sample


class DeepfakeAudioDataset(Dataset):
    def __init__(self, real_audios, fake_audios, transform=None):
        self.transform = transform
        self.audios = real_audios + fake_audios
        random.shuffle(self.audios)

    def __len__(self):
        return len(self.audios)

    def __getitem__(self, idx):
        x = self.audios[idx][0]
        y = self.audios[idx][1]
        if self.transform:
            sample = (self.transform(x), y)
        else:
            sample = (x, y)
        return sample

class DeepFakeDatasetPathListGlcm(Dataset):
    def __init__(self, real_imgs, fake_imgs, transform=None):

        self.transform = transform
        self.imgs = real_imgs + fake_imgs
        random.shuffle(self.imgs)

    def __len__(self):
        return len(self.imgs)

    def __getitem__(self, idx):
        image = Image.open(self.imgs[idx][0]).convert('L')
        image = np.array(image).squeeze()
        image = greycomatrix(image, [5], [0]).squeeze()
        image = Image.fromarray(image).convert('RGB')
        label = self.imgs[idx][1]
        if self.transform:
            sample = (self.transform(image), label)
        else:
            sample = (image, label)
        return sample
