# AttnDreamBooth
## Setup
Our code is primarily based on [Diffusers-DreamBooth](https://github.com/huggingface/diffusers/tree/main/examples/dreambooth) and relies on the [diffusers](https://github.com/huggingface/diffusers) library.
### Set up the Environment
To set up the environment, run the following commands:
```bash
conda env create -f environment.yaml
conda activate AttnDreamBooth
```
### Initialize Accelerate
Initialize an [Accelerate](https://github.com/huggingface/accelerate/) environment with:
```bash
accelerate config
```

### Logging into Huggingface
To use `stabilityai/stable-diffusion-2-1-base` model, you may have to log into Huggingface as follows

+ Use `huggingface-cli` to log in via the Terminal
+ Input your token extracted from [Token](https://huggingface.co/settings/tokens)

## Usage

### Training
You can run the `bash_script/train_attndreambooth.sh` script to train your own model. Before running the training command, please set some important parameters in `train_attndreambooth.sh`:
+ Line **6**: `output_dir`. This is the directory where the fine-tuned model will be saved.
+ Line **8**: `instance_dir`. This is the directory containing the images of the target concept.
+ Line **10**: `category`. This is the category of the target concept.

For example, to train the concept `xxx` in the path `./dataset/xxx`, you need to set the parameters as follows.
```bash
output_dir="./models/"
instance_dir="./dataset/xxx"
category="xxx"
```
To run the training script, use the following command.
```bash
bash bash_script/train_attndreambooth.sh
```
**Notes**:
+ All training arguments can be found in `train_attndreambooth.sh` and are set to their defaults according to the official paper.
+ Please refer to `train_attndreambooth.sh` and `train_attndreambooth.py` for more details on all parameters.

### Inference
You can run the `bash_script/inference.sh` script to generate images. Before executing the inference command, ensure that you have configured the following parameters:
+ Line **2**: `learned_embedding_path`: This is the path to the embeddings learned in the first stage.
+ Line **4**: `checkpoint_path`: This is the path to the fine-tuned models trained in the third stage.
+ Line **6**: `category`: This is the category of the target concept.
+ Line **8**: `output_dir`: This is the directory where the generated images will be saved.

To run the inference, use the following command.
```bash
bash bash_script/inference.sh
```
**Notes**:
+ If you did not set `--only_save_checkpoints` during the training phase, you can specify `--pretrained_model_name_or_path` as the path to the full model, and then omit `--checkpoint_path`.
+ We offer learned embeddings and models for two objects [here](https://drive.google.com/drive/folders/10XFEjFm22jTHuFUx36Cq8MVXYf6ouQhv?usp=sharing) for direct experimentation.
+ For convenience, you can either specify a path of a text file with `--prompt_file`, where each line contains a prompt. For example:
```
A photo of a {}
A {} floats on the water
A {} latte art
```
+ Specify the concept using `{}`, and we will replace it with the concept’s placeholder token and the specified category.
+ The resulting images will be saved in the directory `{save_dir}/{prompt}`

+ For detailed information on all parameters, please consult `inference.py` and `inference.sh`.