function plot_agreements_all(percent4agreements, ratio_lst, method_dspnames, export_name)
% Assuming percent4agreements has the shape (num_methods, num_ratios, 3, 12)
num_methods = size(percent4agreements, 1);
num_ratios = size(percent4agreements, 2);

% Define colors for each agreement type
colors = [0.6350 0.0780 0.1840; 0.4660 0.6740 0.1880; 0.3010 0.7450 0.9330];  % Red, Green, Blue

% Loop over each ratio to create a separate figure
for i = 1:num_ratios
    ratio = ratio_lst(i);
    % Create a new figure for each ratio
    figure;

    % Titles and labels
    title(sprintf('%s (sort %.1f%%)', export_name, ratio*100));
    xlabel('Method');
    ylabel('Average Agreement Percentage');
    
    hold on;

%     % Calculate positions for each group of bars
    offset = [-0.3, 0,  0.3];

    % Iterate through each agreement type
    for type = 1:3
        % Extract the data for the current type and ratio
        agreement_data = squeeze(percent4agreements(:, i, type, :));

        % Calculate the mean and standard deviation of the 12 data points for each method
        mean_agreements = mean(agreement_data, 2);
        std_agreements = std(agreement_data, 0, 2) / sqrt(12);

        % Define bar positions for each type
        positions = (1:num_methods) + offset(type);

        % Plot bars and error bars
        bar_handle = bar(positions, mean_agreements, 0.25, 'FaceColor', colors(type, :),'FaceAlpha',0.5);
        errorbar(positions, mean_agreements, std_agreements, 'k', 'linestyle', 'none');

        % Add scatter plot for individual data points
        for j = 1:num_methods
            x_scatter = repmat(positions(j), 1, 12) + (rand(1, 12) - 0.5) * 0.08; % Slightly jitter the x positions to avoid overlap
            scatter(x_scatter, agreement_data(j, :), 10, 'filled', 'MarkerFaceColor', colors(type, :)); % Use the same color as bars for dots
        end
    end

    hold off;

    % Set x-ticks and labels
    xticks(1:num_methods);
    xticklabels(method_dspnames);

    % Optional: Adjust the legend to reflect the type of agreements
    legend('0-4 Agreement', '1-3 Agreement', '2-2 Agreement', 'Location', 'best');

    if nargin == 4
        filename = sprintf("%s_ratio%s.pdf", export_name, num2str(ratio));
        exportgraphics(gcf,filename,'ContentType','vector')
        fprintf("Bar plot saved - ratio %s\n", num2str(ratio))
    end
end

end