clear
clc


is_D1 =0;
if is_D1
    root_folder = 'straitum/D1';
else
    root_folder = 'straitum/D2';
end
files = dir(root_folder);
k = 2;

current_folder = files(2+k);
load([root_folder '/' current_folder.name]);
choices = 2*valid-1;
valid_act = play_active_learning(metrics,choices,0.01);

s = centroids(2:end,:)-centroids(1:end-1,:);
s = sqrt(sum(s.^2,2));
s = s*5/210*31;
filt = ones(1,30)/30;
c = conv(s,filt,'same');
speeds    = c(1:17999,:);

T_ica = double(T);
S_ica = double(S);
T_ica     = T_ica(:,1:17999);
[nx, ny, k_ica] = size(S_ica);
E_ica = zeros(size(T_ica));
time_decay = 2;


parfor idx = 1:k_ica
    temp = T_ica(idx,:);
    temp_kernel = exp(-(1:5*time_decay)/time_decay);
    tr_dec = deconv([temp,zeros(1,5*time_decay-1)],temp_kernel);
    noise = estimate_noise_std(tr_dec);
    tr_dec(tr_dec < 5*noise ) = 0;
    E_ica(idx,:) =tr_dec;
end
E_ica = single(E_ica)';

smooth_len  = 2.5 ;
temp_x = linspace(-5*smooth_len,5*smooth_len,10*smooth_len+1);
filt = exp(-temp_x.^2 / (2 * smooth_len));
E_ica = conv2(filt, 1, E_ica,'same');
%E_ica = downsample_time(E_ica',5)';
%speeds = downsample_time(speeds',5)';
%
traces      =   E_ica(:,valid == 1);
[~,~,~,preds] = ...
    run_speed_decoders_fixed(traces,speeds);

traces      =   E_ica(:,valid_act == 1);
%traces = traces(:,11:355);
[~,~,~,preds2] = ...
    run_speed_decoders_fixed(traces,speeds);

%%
filt = ones(1,30)/30;
preds_smoothed = conv(preds(1,:),filt);
preds_smoothed = preds_smoothed(1:size(preds,2));
preds_smoothed2 = conv(preds2(1,:),filt);
preds_smoothed2 = preds_smoothed2(1:size(preds,2));
gt = preds(2,:);
%
times = linspace(1,size(preds,2),size(preds,2))/5;
f = figure;
f.Position = [200 200 1200 300];
plot(times,gt,'linewidth',3);
hold on
plot(times,preds_smoothed2,'linewidth',3);
hold on
plot(times,preds_smoothed,'linewidth',3);
hold on

grid off
box off
set(gca,'color','none')
legend('GT', sprintf('TP-Act (%.2f)',corr(gt',preds_smoothed2')), ...
    sprintf('TP-Hum (%.2f)',corr(gt',preds_smoothed')))
exportgraphics(gcf,'plots/speed_comparisons_D2.eps','ContentType','vector')


