% this file is the runner of the active learning averaging over all 12
% annotators using consensus as the ground truth
clear;clc;

exportFlag = 1;

load('twophoton_motion.mat')

annotators = cell(1,4);
annotators{1} = cheetah_choices;
annotators{2} = panda_choices;
annotators{3} = koala_choices;
annotators{4} = dragon_choices;

evaluators = cell(1,4);
evaluators{1} = 2*((panda_choices+koala_choices+dragon_choices)>0)-1;
evaluators{2} = 2*((cheetah_choices+koala_choices+dragon_choices)>0)-1;
evaluators{3} = 2*((cheetah_choices+panda_choices+dragon_choices)>0)-1;
evaluators{4} = 2*((cheetah_choices+panda_choices+koala_choices)>0)-1;

features    = metrics';
infs = isinf(features);
features(infs) = 0;
features = zscore(features, 0, 1);
features(infs) = 0;
groundTruth = dragon_choices';
%%
[XL, YL, XS, YS, Beta, PCTVAR] = plsregress(features, groundTruth, 3);

figure
scatter3(XS(groundTruth==1,1),XS(groundTruth==1,2),XS(groundTruth==1,3),8,'filled',MarkerEdgeColor='none',MarkerFaceColor='#0072BD',...
    MarkerFaceAlpha=0.7);hold on
scatter3(XS(groundTruth==-1,1),XS(groundTruth==-1,2),XS(groundTruth==-1,3),8,'filled',MarkerEdgeColor='none',MarkerFaceColor='#cc0000',...
    MarkerFaceAlpha=0.7);

axis off
% grid minor
title('Ground Truth')
hold off
axis equal
view(2)
set(gcf,color='w')
grid off
% pause(0.1)
set(gca,"FontSize",14)
% ylim([-15 30])
% xlim([-10 30])
legend('Cell','Not cell')
if exportFlag == 1
    exportgraphics(gcf,'pls_oscar.pdf', 'ContentType','vector')
end