# Replica Semantic Segmentation Mapping
REPLICA_MAPPING = {
    0: 0, 2: 255, 3: 1, 6: 255, 7: 2, 8: 3, 9: 255, 10: 4, 11: 5, 
    12: 6, 13: 7, 14: 8, 15: 9, 16: 10, 17: 11, 18: 12, 19: 255, 
    20: 13, 21: 255, 22: 14, 23: 255, 24: 255, 25: 255, 26: 15, 
    28: 255, 29: 16, 30: 255, 31: 17, 32: 255, 33: 255, 34: 255, 
    35: 18, 37: 19, 39: 255, 40: 20, 41: 255, 43: 255, 44: 21, 
    45: 255, 46: 255, 47: 22, 49: 255, 50: 255, 52: 255, 54: 23, 
    55: 255, 56: 24, 59: 25, 60: 26, 61: 27, 62: 255, 63: 28, 64: 29, 
    65: 30, 66: 31, 67: 255, 68: 255, 69: 255, 70: 32, 71: 255, 72: 255, 
    73: 255, 74: 255, 75: 255, 76: 33, 77: 255, 78: 34, 79: 35, 80: 36, 
    82: 37, 83: 38, 84: 255, 86: 255, 87: 39, 88: 255, 89: 255, 90: 255, 
    91: 40, 92: 41, 93: 42, 94: 255, 95: 43, 97: 44, 98: 45, 100: 255, 255: 255
}

# SCANNET++ Semantic Segmentation Mapping
SCANNET_PP_MAPPING = {
    1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 8, 11: 6, 12: 10, 13: 9, 14: 11, 16: 7, 18: 12, 19: 10, 21: 13,
    26: 6, 27: 10, 28: 14, 29: 15, 31: 16, 32: 16, 33: 2, 34: 17, 36: 18, 37: 19, 43: 20, 44: 21, 45: 5, 46: 22, 47: 23, 48: 24, 49: 24, 50: 25,
    55: 26, 56: 27, 57: 28, 58: 23, 59: 29, 60: 30, 61: 31, 62: 32, 63: 8, 64: 25, 66: 5, 67: 33, 68: 34, 69: 35, 70: 36, 71: 27, 72: 37, 73: 10, 75: 38,
    78: 25, 82: 39, 87: 8, 88: 13, 89: 21, 91: 30, 95: 40, 97: 41, 100: 6, 102: 6, 106: 42, 107: 43, 108: 44, 109: 14, 111: 29, 114: 45, 116: 41, 118: 31, 119: 62,
    120: 5, 125: 6, 129: 46, 130: 10, 133: 47, 135: 5, 136: 4, 139: 14, 140: 25, 141: 6, 143: 5, 144: 4, 145: 24, 149: 8, 151: 22, 152: 48, 154: 17, 158: 25, 159: 5,
    162: 49, 166: 6, 167: 50, 169: 9, 170: 23, 173: 9, 174: 51, 178: 19, 187: 1, 188: 1, 189: 44, 191: 7, 194: 9, 198: 52, 199: 14, 201: 9, 202: 9, 206: 2, 209: 7,
    210: 44, 214: 5, 215: 61, 216: 1, 217: 7, 220: 7, 222: 19, 225: 5, 229: 9, 232: 5, 233: 3, 235: 5, 237: 5, 239: 15, 241: 9, 243: 20, 244: 7, 245: 9, 246: 6,
    247: 10, 248: 1, 251: 25, 252: 15, 257: 33, 259: 33, 263: 4, 265: 26, 267: 43, 268: 33, 269: 53, 270: 54, 275: 40, 279: 14, 285: 55, 286: 5, 293: 36, 301: 55,
    305: 23, 309: 6, 316: 27, 319: 6, 320: 20, 321: 5, 322: 8, 326: 5, 327: 10, 328: 27, 343: 51, 346: 7, 350: 17, 351: 28, 361: 44, 370: 7, 376: 30, 379: 9, 382: 14,
    387: 9, 390: 21, 394: 8, 395: 10, 405: 7, 411: 44, 416: 27, 417: 62, 418: 29, 428: 14, 429: 9, 431: 5, 432: 44, 437: 24, 438: 56, 441: 24, 454: 5, 457: 47, 459: 15,
    460: 22, 467: 8, 473: 7, 485: 9, 488: 28, 491: 7, 497: 10, 498: 25, 501: 28, 503: 41, 504: 31, 505: 9, 506: 5, 507: 6, 509: 25, 518: 26, 521: 5, 522: 6, 524: 33,
    525: 25, 526: 10, 528: 10, 529: 25, 530: 29, 531: 7, 532: 22, 535: 9, 536: 23, 539: 24, 540: 5, 545: 23, 551: 25, 553: 7, 554: 5, 557: 6, 562: 27, 564: 57, 570: 7,
    571: 32, 572: 25, 575: 42, 576: 27, 583: 30, 587: 10, 591: 28, 597: 28, 602: 7, 603: 6, 608: 28, 610: 43, 611: 62, 612: 7, 614: 28, 615: 43, 622: 10, 624: 23, 625: 27,
    631: 44, 636: 12, 637: 9, 639: 44, 640: 9, 644: 16, 658: 10, 661: 10, 664: 44, 669: 51, 679: 7, 682: 5, 683: 40, 685: 27, 686: 24, 697: 28, 705: 33, 711: 43, 712: 33,
    713: 4, 716: 24, 717: 10, 721: 1, 723: 30, 727: 28, 734: 5, 735: 25, 736: 22, 738: 9, 741: 33, 752: 25, 758: 4, 763: 25, 767: 58, 768: 28, 770: 28, 781: 23, 783: 5,
    784: 31, 785: 28, 787: 26, 789: 54, 794: 25, 799: 62, 801: 28, 823: 7, 824: 59, 828: 5, 830: 33, 833: 26, 841: 60, 845: 44, 846: 16, 851: 31, 858: 33, 859: 44, 863: 27,
    868: 33, 872: 43, 884: 7, 885: 30, 886: 7, 899: 44, 900: 10, 904: 28, 906: 31, 915: 5, 935: 16, 941: 7, 946: 37, 947: 5, 950: 9, 951: 24, 957: 31, 964: 31, 966: 24,
    1000: 2, 1019: 60, 1030: 27, 1031: 7, 1033: 22, 1051: 62, 1059: 29, 1095: 62, 1107: 25, 1108: 7, 1115: 30, 1130: 10, 1131: 31, 1145: 10, 1148: 23, 1159: 27, 1164: 33,
    1168: 28, 1193: 62, 1194: 7, 1222: 24, 1229: 60, 1257: 43, 1285: 55, 1288: 7, 1293: 60, 1367: 62, 1389: 61, 1411: 7, 1414: 44, 1423: 62, 1424: 7, 1428: 28, 1440: 55,
    1442: 62, 1454: 7, 1460: 62, 1467: 7, 1475: 62, 1499: 62, 1519: 62, 1523: 61, 1539: 61, 1542: 47, 1555: 61, 1558: 61, 1577: 7, 1592: 7, 1606: 47, 1607: 47, 1655: 62,
    1658: 31, 9999: 255,
}

# Add all 255 values
for i in range(1, 1660):
    if i not in SCANNET_PP_MAPPING:
        SCANNET_PP_MAPPING[i] = 255