from utils import *
from torch.utils.data import Dataset
import torch
import random
import os
from tqdm import trange
import pickle
import numpy as np
from tempfile import TemporaryFile


class InContextDataset(Dataset):
    def __init__(self, N, num_example, num_var=5, start_curriculum=1):
        """
        N: number of samples
        num_example: number of examples in one input
        num_var: number of variables in the Markov Chain
        """
        self.N = N
        self.num_example = num_example
        self.num_var = num_var
        self.graphs = []
        self.mask_out_range = [0, start_curriculum]

        if os.path.exists(f"./dataset/general_graph.npy"):
            with open(f"./dataset/general_graph.npy", 'rb') as f:
                self.data = torch.from_numpy(np.load(f))
                self.graphs.append(get_general_network())

        else:
            self.data = []
            for i in trange(1000):
                self.graphs.append(get_general_network())
          
            for i in trange(1000):
                examples = self.graphs[i].to_onehot(self.graphs[i].sample(2000)) # (4000, -1)
                self.data.append(examples)
            self.graphs = [get_general_network_test()]
            self.data = torch.stack(self.data, dim=0)
            npy = self.data.numpy()
            with open(f"./dataset/general_graph.npy", 'wb') as f:
                np.save(f, npy)
            
    def update_mode(self, mode):
        self.mode = mode

    def __len__(self):
        return self.N

    def __getitem__(self, idx):
        
        graph_idx = random.randint(0, 999)
        sampled_idx = torch.randint(0, 2000, (self.num_example+1,))
        example_idx = sampled_idx[:self.num_example]
        test_idx = sampled_idx[-1]
        examples = self.data[graph_idx][example_idx]
        # examples = self.graphs[graph_idx].to_onehot(self.graphs[graph_idx].sample(self.num_example))
        test_token = self.data[graph_idx][test_idx].unsqueeze(0).argmax(-1)
        mask_out = random.randint(self.mask_out_range[0], self.mask_out_range[1])
      
        y = test_token[:, mask_out]
        test_token = self.graphs[0].to_onehot(test_token)

        test_token = self.graphs[0].mask_var(test_token, mask_out)
        test_token = test_token.view(test_token.size(0), -1)
        pos_enc = torch.zeros(examples.size(0), self.num_var)
        examples = examples.view(examples.size(0), -1)
        examples = torch.cat([examples, pos_enc], dim=-1)
        return torch.cat([examples, test_token], dim=0), y
    

class InContextDatasetTest(Dataset):
    def __init__(self, N, num_example, mask_out, num_var=5):
        """
        N: number of samples
        num_example: number of examples in one input
        """

        self.N = N
        self.num_example = num_example
        self.mask_out = mask_out
        self.num_var = num_var

        self.graphs = []

        if os.path.exists(f"./dataset/test_general_graph.npy"):
            self.graphs.append(get_general_network_test())
            with open(f"./dataset/test_general_graph.npy", 'rb') as f:
                self.data = torch.from_numpy(np.load(f)) # (1, 50000, 4)
        else:
            self.data = []
            for i in trange(1):
                self.graphs.append(get_general_network_test())

            for i in trange(1):
                examples = self.graphs[i].to_onehot(self.graphs[i].sample(50000)) # (50000, 4, 2)
                self.data.append(examples)
            self.data = torch.stack(self.data, dim=0)
            npy = self.data.numpy()
            with open(f"./dataset/test_general_graph.npy", 'wb') as f:
                np.save(f, npy)
        self.num_var = 5
    def update_mask_out(self, m):
        self.mask_out = m
      
    def update_num_example(self, m):
        self.num_example = m
  
    def __len__(self):
        return self.N

    def __getitem__(self, idx):

        # torch.manual_seed(idx)
        # random.seed(idx)
        graph_idx = 0
        sampled_idx = torch.randint(0, 50000, (self.num_example+1,))
        example_idx = sampled_idx[:self.num_example]
        test_idx = sampled_idx[-1]
        examples = self.data[graph_idx][example_idx]
        # examples = self.graphs[graph_idx].to_onehot(self.graphs[graph_idx].sample(self.num_example))
        test_token = self.data[graph_idx][test_idx].argmax(-1).unsqueeze(0)
        mask = torch.tensor([[True]*5])

        if self.mask_out == 0 or self.mask_out == 1:
            mask[:, self.mask_out:] = False
        elif self.mask_out == 2 or self.mask_out == 3:
            mask[:, 2:] = False
        elif self.mask_out == 4:
            mask[:, 4:] = False

        X_masked = torch.masked.MaskedTensor(test_token, mask=mask)
        graph_pred = self.graphs[graph_idx].graph.predict(X_masked)[:, self.mask_out].squeeze(0)

        mask_out = self.mask_out
        y = test_token[:, mask_out]
        test_token = self.graphs[graph_idx].to_onehot(test_token)
        test_token = self.graphs[0].mask_var(test_token, mask_out)
        probs = self.graphs[0].get_prob(mask_out)
        test_token = test_token.view(test_token.size(0), -1)
      
        pos_enc = torch.zeros(examples.size(0), self.num_var)
        examples = examples.view(examples.size(0), -1)

        examples = torch.cat([examples, pos_enc], dim=-1)
        return torch.cat([examples, test_token], dim=0), y, probs, graph_pred