'''
Author: 
Email: 
Date: 2021-07-20 01:11:54
LastEditTime: 2022-04-04 23:09:02
Description: 
'''
import numpy as np
import pyglet


class Renderer(pyglet.window.Window):
    color = {'background': [1]*3 + [1], 'road': (220, 220, 220)*4, 'sensor': (73, 73, 73)*2}

    def __init__(self, width, height, agent_list):
        super(Renderer, self).__init__(width, height, resizable=False, caption='2D Simulator', vsync=False)  # vsync=False to not use the monitor FPS
        self.set_location(x=80, y=10)
        pyglet.gl.glClearColor(*self.color['background'])
        self.batch = pyglet.graphics.Batch()
        background = pyglet.graphics.OrderedGroup(0)
        foreground = pyglet.graphics.OrderedGroup(1)
        self.frame_cnt = 0

        # message info
        self.frame_label = pyglet.text.Label('Frame: 0', color=[0, 0, 0, 255], font_size=10, x=5, y=195, anchor_x='left', anchor_y='top', batch=self.batch, group=foreground)
        self.ego_speed_label = pyglet.text.Label('Ego Speed: N/A', color=[0, 0, 0, 255], font_size=10, x=10, y=470, anchor_x='left', anchor_y='top', batch=self.batch, group=foreground)
        self.ped_speed_label = pyglet.text.Label('Ped Speed: N/A', color=[0, 0, 0, 255], font_size=10, x=10, y=450, anchor_x='left', anchor_y='top', batch=self.batch, group=foreground)
        self.arrow_1 = pyglet.text.Label('↓', color=[0, 0, 0, 255], font_size=20, x=45, y=20, anchor_x='center', anchor_y='center', batch=self.batch, group=foreground)
        self.arrow_2 = pyglet.text.Label('↓', color=[0, 0, 0, 255], font_size=20, x=80, y=20, anchor_x='center', anchor_y='center', batch=self.batch, group=foreground)
        self.arrow_3 = pyglet.text.Label('↑', color=[0, 0, 0, 255], font_size=20, x=120, y=20, anchor_x='center', anchor_y='center', batch=self.batch, group=foreground)
        self.arrow_4 = pyglet.text.Label('↑', color=[0, 0, 0, 255], font_size=20, x=155, y=20, anchor_x='center', anchor_y='center', batch=self.batch, group=foreground)

        # process vehicle information
        self.n_actors = len(agent_list)
        self.agents = []
        start_rect = [0, 0] * 4
        for a_i in range(self.n_actors):
            agent_param = agent_list[a_i]
            agent_color = agent_param['color'] * 4
            agent = self.batch.add(4, pyglet.gl.GL_QUADS, foreground, ('v2f', start_rect), ('c3B', agent_color))
            self.agents.append(agent)

        # process sensor information
        self.sensors = []
        line_coord = [0, 0] * 2
        for a_i in range(self.n_actors):
            sensor = []
            agent_param = agent_list[a_i]
            for _ in range(agent_param['n_sensor']):
                sensor.append(self.batch.add(2, pyglet.gl.GL_LINES, foreground, ('v2f', line_coord), ('c3B', self.color['sensor'])))
            self.sensors.append(sensor)

        # process road and lane (no physical contact)
        left_top_list = [[30, 200], [65, 200], [105, 200], [140, 200]]
        right_bottom_list = [[60, 0], [95, 0], [135, 0], [170, 0]]
        for r_i in range(len(left_top_list)):
            left_top = left_top_list[r_i]
            right_bottom = right_bottom_list[r_i]
            road_shape = [left_top[0], right_bottom[1], right_bottom[0], right_bottom[1], right_bottom[0], left_top[1], left_top[0], left_top[1]]
            self.batch.add(4, pyglet.gl.GL_QUADS, background, ('v2f', road_shape), ('c3B', self.color['road']))

    def render(self, agent_info, sensor_info, label_info):
        pyglet.clock.tick()
        self._update(agent_info, sensor_info, label_info)
        self.switch_to()
        self.dispatch_events()
        self.dispatch_event('on_draw')
        self.flip()
        self.frame_cnt += 1

    def save_image(self):
        filename = '/tmp/' + str(self.frame_cnt) + '.png'
        pyglet.image.get_buffer_manager().get_color_buffer().save(filename)

    def on_draw(self):
        self.clear()
        self.batch.draw()

    def _update(self, agent_info, sensor_info, label_info):
        assert self.n_actors == len(agent_info) == len(sensor_info), 'Agent number does not match'
        self.frame_label.text = 'Frame: ' + str(label_info['frame_num'])
        self.ego_speed_label.text = 'Ego Speed: ' + '%.2f' % label_info['ego_speed']
        self.ped_speed_label.text = 'Ped Speed: ' + '%.2f' % label_info['ped_speed']

        for a_i in range(self.n_actors):
            cx, cy, _, rotation, width, length = agent_info[a_i]

            # sensors
            for i, sensor in enumerate(self.sensors[a_i]):
                sensor.vertices = [cx, cy, *sensor_info[a_i][i, -2:]]

            # car
            xys = [
                [cx - width / 2, cy - length / 2],
                [cx + width / 2, cy - length / 2],
                [cx + width / 2, cy + length / 2],
                [cx - width / 2, cy + length / 2],
            ]

            r_xys = []
            for x, y in xys:
                #tempX = x - cx
                #tempY = y - cy
                # apply rotation
                #rotatedX = tempX * np.cos(rotation) - tempY * np.sin(rotation)
                #rotatedY = tempX * np.sin(rotation) + tempY * np.cos(rotation)
                # rotated x y
                #x = rotatedX + cx
                #y = rotatedY + cy
                r_xys += [x, y]
            self.agents[a_i].vertices = r_xys
