import argparse
import torch
import torch.nn.functional as F
from torch_geometric.nn import SGConv

from citation import get_planetoid_dataset, random_planetoid_splits, run
from citation.train_eval import random_geom_splits, random_splits
from other_datasets import *
import torch_geometric.transforms as T
from torch_geometric.nn  import SAGEConv
parser = argparse.ArgumentParser()
parser.add_argument('--dataset', type=str, default='cornell')
parser.add_argument('--random_splits', type=bool, default=False)
parser.add_argument('--runs', type=int, default=10)
parser.add_argument('--epochs', type=int, default=1000)
parser.add_argument('--lr', type=float, default=0.1)
parser.add_argument('--weight_decay', type=float, default=0.0005)
parser.add_argument('--early_stopping', type=int, default=100)
parser.add_argument('--normalize_features', type=bool, default=False)
parser.add_argument('--K', type=int, default=2)
parser.add_argument('--attack', type=str, default='no')
parser.add_argument('--ptb_rate', type=float, default=0.05)
args = parser.parse_args()


class Net(torch.nn.Module):
    def __init__(self, dataset):
        super(Net, self).__init__()
        self.num_layers = num_layers=args.K
        self.convs = torch.nn.ModuleList()
        self.convs.append(SAGEConv(dataset.num_features, dataset.num_classes))
        for _ in range(num_layers - 2):
            self.convs.append(SAGEConv(hidden_channels, hidden_channels))
        self.convs.append(SAGEConv(hidden_channels, out_channels))

    def reset_parameters(self):
        for conv in self.convs:
            conv.reset_parameters()

    def forward(self, x, adjs):
        # `train_loader` computes the k-hop neighborhood of a batch of nodes,
        # and returns, for each layer, a bipartite graph object, holding the
        # bipartite edges `edge_index`, the index `e_id` of the original edges,
        # and the size/shape `size` of the bipartite graph.
        # Target nodes are also included in the source nodes so that one can
        # easily apply skip-connections or add self-loops.
        for i, (edge_index, _, size) in enumerate(adjs):
            x_target = x[:size[1]]  # Target nodes are always placed first.
            x = self.convs[i]((x, x_target), edge_index)
            if i != self.num_layers - 1:
                x = F.relu(x)
                x = F.dropout(x, p=0.5, training=self.training)
        return x.log_softmax(dim=-1)

if args.attack in ['random', 'meta']:
    dataset = AttackedDataset('', args.dataset, transforms=T.NormalizeFeatures(), args=args)
    permute_masks = None
    permute_masks = random_splits if args.random_splits else None
else:
    if args.dataset in ['cora', 'citeseer', 'pubmed']:
        dataset = get_planetoid_dataset(args.dataset, args.normalize_features)
        # permute_masks = random_planetoid_splits if args.random_splits else None
        permute_masks = random_geom_splits if args.random_splits else None
    else:
        import torch_geometric.transforms as T
        dataset = OtherDataset('', args.dataset, transform=T.NormalizeFeatures())
        permute_masks = random_splits if args.random_splits else None
        # if args.dataset != 'nell':
        #     permute_masks = random_planetoid_splits
        if args.dataset in ['chameleon', 'squirrel', 'film', 'cornell', 'texas', 'wisconsin']:
            permute_masks = random_geom_splits

# import logging
# if args.ptb_rate > 0:
#     LOG_FILENAME = 'log/sgc_noise.log'
# else:
#     LOG_FILENAME = 'log/sgc.log'
# logging.basicConfig(filename=LOG_FILENAME,level=logging.DEBUG)
# logging.debug(args)
# # logging.debug(f'Dataset {args.dataset}, hidden {args.hidden}, weight_decay {args.weight_decay}, lr {args.lr}, normalize_features {args.normalize_features}, ptb_rate {args.ptb_rate}')

run(dataset, Net(dataset), args.runs, args.epochs, args.lr, args.weight_decay,
    args.early_stopping, permute_masks, name=args.dataset, ptb_rate=args.ptb_rate)

