import argparse
import torch
import torch.nn.functional as F
from dmp_conv import *
from torch_geometric.nn import SAGEConv
from citation import get_planetoid_dataset, random_planetoid_splits
from citation import run
from citation.train_eval import random_geom_splits, random_splits
from other_datasets import *
import torch_geometric.transforms as T
import torch_geometric.transforms as T

parser = argparse.ArgumentParser()
parser.add_argument('--dataset', type=str, default='squirrel')
parser.add_argument('--random_splits', type=bool, default=False)
parser.add_argument('--runs', type=int, default=1)
parser.add_argument('--epochs', type=int, default=1000)
parser.add_argument('--lr', type=float, default=0.005)
parser.add_argument('--weight_decay', type=float, default=0.0005)
parser.add_argument('--early_stopping', type=int, default=200)
parser.add_argument('--hidden', type=int, default=16)
parser.add_argument('--dropout', type=float, default=0.30)
parser.add_argument('--normalize_features', type=bool, default=True)
parser.add_argument('--heads', type=int, default=16)
parser.add_argument('--output_heads', type=int, default=1)
parser.add_argument('--lambda_', type=float, default=1)
parser.add_argument('--attack', type=str, default='no')
parser.add_argument('--ptb_rate', type=float, default=0)
parser.add_argument('--K', type=int, default=32)

args = parser.parse_args()



class Net(torch.nn.Module):
    def __init__(self, dataset):
        super(Net, self).__init__()
        self.conv1 = DMPConv(
            dataset.num_features,
            args.hidden,
            heads=args.heads,
            dropout=args.dropout, lambda_=args.lambda_,K=args.K)
        self.conv2 = DMPConv(
            args.hidden * args.heads,
            dataset.num_classes,
            heads=args.output_heads,
            concat=False,
            dropout=args.dropout, lambda_=args.lambda_,K=1)

    def reset_parameters(self):
        self.conv1.reset_parameters()
        self.conv2.reset_parameters()

    def forward(self, data):
        x, edge_index = data.x, data.edge_index
        if args.dataset != 'nell':
            x = F.dropout(x, p=args.dropout, training=self.training)
        x = F.elu(self.conv1(x, edge_index))
        x = F.dropout(x, p=args.dropout, training=self.training)
        x = self.conv2(x, edge_index)
        return F.log_softmax(x, dim=1)


if args.attack in ['random', 'meta']:
    dataset = AttackedDataset('', args.dataset, transforms=T.NormalizeFeatures(), args=args)
    permute_masks = None
    permute_masks = random_splits if args.random_splits else None
else:
    if args.dataset in ['cora','citeseer', 'pubmed']:
        dataset = get_planetoid_dataset(args.dataset, args.normalize_features)
        # permute_masks = random_planetoid_splits if args.random_splits else None
        permute_masks = random_geom_splits if args.random_splits else None
    else:
        dataset = OtherDataset('/home/user/lmz/mlearning/code_can_run_4.9/new_data', args.dataset, transform=T.NormalizeFeatures())
        permute_masks = random_splits if args.random_splits else None
        if args.dataset in ['chameleon', 'squirrel', 'film', 'cornell', 'texas', 'wisconsin','cora','citeseer', 'pubmed']:
            permute_masks = random_geom_splits

run(dataset, Net(dataset), args.runs, args.epochs, args.lr, args.weight_decay,
    args.early_stopping, permute_masks, name=args.dataset, ptb_rate=args.ptb_rate)
