import argparse
import torch
import torch.nn.functional as F
from gcn_conv_copy import GCNConv 

from citation import get_planetoid_dataset, random_planetoid_splits, run
from citation.train_eval import random_geom_splits, random_splits
from other_datasets import *
import torch_geometric.transforms as T
from gravnet_conv import GravNetConv 
from gcn_conv_ import GCNConv_1
import numpy as np 


parser = argparse.ArgumentParser()
parser.add_argument('--dataset', type=str, default='cora')
parser.add_argument('--random_splits', type=bool, default=False)
parser.add_argument('--runs', type=int, default=3)
parser.add_argument('--epochs', type=int, default=1000)
parser.add_argument('--lr', type=float, default=0.01)
parser.add_argument('--weight_decay', type=float, default=0.0005)
parser.add_argument('--early_stopping', type=int, default=200)
parser.add_argument('--hidden', type=int, default=64)
parser.add_argument('--dropout', type=float, default=0.5)
parser.add_argument('--normalize_features', type=bool, default=True)
parser.add_argument('--attack', type=str, default='no')
parser.add_argument('--ptb_rate', type=float, default=0.05)
args = parser.parse_args()


class Net(torch.nn.Module):
    def __init__(self, dataset):
        super(Net, self).__init__()
        self.conv1 = GCNConv(dataset.num_features, args.hidden)
        self.conv2 = GCNConv(args.hidden, dataset.num_classes)

    def reset_parameters(self):
        self.conv1.reset_parameters()
        self.conv2.reset_parameters()

    def forward(self, data):
        x, edge_index = data.x, data.edge_index
        x = F.relu(self.conv1(x, edge_index))
        x = F.dropout(x, p=args.dropout, training=self.training)
        x = self.conv2(x, edge_index)
        # num=x.shape[0]
        # a = np.random.binomial(n=1,p=0.5,size=(num,1))
        # a=torch.from_numpy(a).cuda(1)
        # x=x*a
        return F.log_softmax(x, dim=1)

if args.attack in ['random', 'meta']:
    dataset = AttackedDataset('', args.dataset, transforms=T.NormalizeFeatures(), args=args)
    permute_masks = None
    permute_masks = random_splits if args.random_splits else None
else:
    if args.dataset in ['cora', 'citeseer', 'pubmed']:
        dataset = get_planetoid_dataset(args.dataset, args.normalize_features)
        # permute_masks = random_planetoid_splits if args.random_splits else None
        permute_masks = random_geom_splits if args.random_splits else None
    else:
        import torch_geometric.transforms as T
        dataset = OtherDataset('', args.dataset, transform=T.NormalizeFeatures())
        permute_masks = random_splits if args.random_splits else None
        # if args.dataset != 'nell':
        #     permute_masks = random_planetoid_splits
        if args.dataset in ['chameleon', 'squirrel', 'film', 'cornell', 'texas', 'wisconsin']:
            permute_masks = random_geom_splits

# edge=edge_index=dataset.data.edge_index
# edge_index_i,edge_index_j = edge_index
# second_neighbour=None
# for edge_num in range(edge_index_i.shape[0]):
#     for index_i in range(edge_index_i.shape[0]):
#         if edge_index_j[edge_num] == edge_index_i[index_i] and edge_index_i[edge_num] !=edge_index_j[index_i] :
#             x_i=edge_index_i[edge_num].view(-1,1)
#             x_j=edge_index_j[index_i].view(-1,1)
#             index=torch.cat((x_i,x_j),axis = 0)
#             if second_neighbour==None:
#                 second_neighbour=index
#             else:
#                 second_neighbour=torch.cat((second_neighbour,index),axis=1)
# edge_index=torch.cat((edge,second_neighbour),axis=1)
# uniques = np.unique(edge_index.T.numpy(),axis=0)
# edge_index=torch.from_numpy(uniques)
# dataset.data.edge_index=edge_index.T


import logging
LOG_FILENAME = 'log/gcn_noise.log'
logging.basicConfig(filename=LOG_FILENAME,level=logging.DEBUG)
logging.debug(f'Dataset {args.dataset}, hidden {args.hidden}, weight_decay {args.weight_decay}, lr {args.lr}, normalize_features {args.normalize_features}, ptb_rate {args.ptb_rate}')

run(dataset, Net(dataset), args.runs, args.epochs, args.lr, args.weight_decay,
    args.early_stopping, permute_masks, name=args.dataset, ptb_rate=args.ptb_rate)

