# Supplementary Material for "Towards Photorealistic Video Colorization via Gated Color-Guided Image Diffusion Models"

## Overview

The repository contains videos generated using our model for video colorization, along with comparison videos of other automatic and example-based video colorization models. It provides additional information and results to complement the main content of the paper.

## Folder Structure

- videos /
    - Automatic_Colorization_Comparison /
        - auto_colorize_case1.mp4
        - auto_colorize_case2.mp4
        - auto_colorize_case3.mp4
        >Comparison of automatic video colorization methods Deoldify, TCVC, and VCGAN. The videos concatenate Input, Ground Truth, and results from multiple methods for easy visual comparison, with the logo of Input, Ground Truth, or the corresponding method name displayed in the bottom left corner of each small video.

    - Example-based_Colorization_Comparison /
        - example_based_colorize_case1.mp4
        - example_based_colorize_case2.mp4
        - example_based_colorize_case3.mp4
        >Comparison with reference-based video colorization methods DRemaster, DExample, and BisTNet, where the first frame of Ground Truth serves as the reference frame for the video. The videos concatenate Input, Ground Truth, and results from multiple methods for easy visual comparison, with the logo of Input, Ground Truth, or the corresponding method name displayed in the bottom left corner of each small video.
        
    - Text-Guided_Colorization /
        - text_guided_colorize_case1.mp4
        - text_guided_colorize_case2.mp4
        - text_guided_colorize_case3.mp4
        - text_guided_colorize_case4.mp4
        - text_guided_colorize_case5.mp4
        - text_guided_colorize_case6.mp4
        >Demonstrates our method's colorization results on grayscale videos using different prompts. For intuitive presentation, we concatenate different results of the same grayscale video into one large video, with subtitles indicating the corresponding prompts for each small video.
    
- Supplementary_Material.pdf

