
# Prediction Tasks in Graphs: a Framework to Control the Interpretability-Performance Trade-off


## Description
Welcome to the repository for our scientific article "Prediction Tasks in Graphs: a Framework to Control the Interpretability-Performance Trade-off", which we have submitted to the ICLR 2024 conference. This repository contains all the source code used in our research. We appreciate your interest in our work and hope you find it valuable.

## Installation
To get started, please follow these installation instructions:

Create a new conda environment by running the following command in your terminal:

```bash
conda create --name gcip python=3.9.12 --no-default-packages
 ```

Activate the conda environment using the following command:

```bash
conda activate gcip
 ```

Install the additional project requirements using pip and the `requirements.txt` file:

```bash
pip install -r requirements.txt
```


Once the installation is completed, run the following commands in your terminal to check everything worked:

```bash
python main.py --config_file gcip/configs/gcip.yaml --wandb_mode disabled --project GCIP
python main.py --config_file gcip/configs/gnn.yaml --wandb_mode disabled --project GCIP
python main.py --config_file gcip/configs/gnn_pooling.yaml --wandb_mode disabled --project GCIP

```


# Experiments

The experiments of the paper can be generated running the following commands:

```bash
python generate_jobs.py --grid_file grids/gcip/gin/gin.yaml --format shell --jobs_per_file 20000 --batch_size 4 --delete_ckpt

python generate_jobs.py --grid_file grids/gcip/top_k/gin.yaml --format shell --jobs_per_file 3000 --batch_size 1 --delete_ckpt


python generate_jobs.py --grid_file grids/gcip/top_k_hard/gin.yaml --format shell --jobs_per_file 3000 --batch_size 10 --delete_ckpt

python generate_jobs.py --grid_file grids/gcip/diff_pool/gin.yaml --format shell --jobs_per_file 3000 --batch_size 10 --delete_ckpt


python generate_jobs.py --grid_file grids/gcip/gcip_lambda/gin.yaml --format shell --jobs_per_file 3000 --batch_size 1 --delete_ckpt

python generate_jobs.py --grid_file grids/gcip/gcip_lambda_2/gin.yaml --format shell --jobs_per_file 3000 --batch_size 1 --delete_ckpt

python generate_jobs.py --grid_file grids/gcip/gcip_d/gin.yaml --format shell --jobs_per_file 800 --batch_size 1 --delete_ckpt

python generate_jobs.py --grid_file grids/gcip/gcip_d_2/gin.yaml --format shell --jobs_per_file 1800 --batch_size 1 --delete_ckpt

```