from gcip.preparators import data_preparator_dict, data_preparator_loader_dict
from .bzr import BZRreparator
from .cox2 import COX2reparator
from .dd import DDPreparator
from .enzymes import ENZYMESPreparator
from .mutag import MUTAGPreparator
from .nci1 import NCI1Preparator
from .nci109 import NCI109Preparator
from .proteins import PROTEINSPreparator
from .ptc import PTCPreparator

data_preparator_dict_graph = {
    'mutag': MUTAGPreparator,
    'enzymes': ENZYMESPreparator,
    'nci1': NCI1Preparator,
    'ptc': PTCPreparator,
    'nci109': NCI109Preparator,
    'proteins': PROTEINSPreparator,
    'dd': DDPreparator,
    'cox2': COX2reparator,
    'bzr': BZRreparator,
}

data_preparator_dict.update(data_preparator_dict_graph)

for class_name, class_ in data_preparator_dict_graph.items():
    data_preparator_loader_dict[class_name] = class_.loader
