class WrongNumberOfLayers(Exception):
    """Exception raised for errors in the number of layers of a component.
    """

    def __init__(self, num_layers):
        self.message = f"Wrong number of layers - num_layers: {num_layers}"
        super().__init__(self.message)


class WrongLoss(Exception):
    """
    Exception raised for errors in the number of layers of a component.

    """

    def __init__(self, loss_name):
        self.message = f"Wrong loss: {loss_name}"
        super().__init__(self.message)

class WrongDimensions(Exception):
    """
    Exception raised for errors in the number of layers of a component.

    """

    def __init__(self, input_dim, output_dim):
        self.message = f"Wrong dimensions: [{input_dim}, {output_dim}]"
        super().__init__(self.message)


class NotFoundInDB(Exception):
    """
    Exception raised when documents are not found in DB

    """

    def __init__(self, message):
        self.message = f"{message} not found in DB"
        super().__init__(self.message)


