import torch
from gcip.utils.io import dict_to_cn

import numpy as np

from abc import abstractmethod

import torch.nn as nn

class KernelBase(nn.Module):
    def __init__(self, name, requires_grad):
        super(KernelBase, self).__init__()
        self.name = name
        self.requires_grad = requires_grad

    @abstractmethod
    def reset_parameters(self):
        pass

    @abstractmethod
    def set_params(self, *args):
        pass

    @abstractmethod
    def forward(self,  t):
        pass


    @abstractmethod
    def integrate(self, t_init, t_end, t_i):
        pass
