from gcip.config import get_config_default_file
from gcip.preparators import data_preparator_dict
from gcip.preparators import data_preparator_loader_dict


def load_preparator(cfg, prepare_data=True):
    preparator = data_preparator_loader_dict[cfg.dataset.name](cfg.dataset)
    if prepare_data:
        preparator.prepare_data()

    return preparator


def load_preparator_from_filename(filename):
    cfg = get_config_default_file(as_dict=False)
    cfg.merge_from_file(filename)
    values = cfg.dataset
    values.single_split = None
    values.include_idx = True
    name = values.name

    Preparator = data_preparator_dict[name]
    preparator = Preparator.loader(values)
    preparator.prepare_data()
    return preparator
