import numpy as np
import itertools
import torch

def index_to_one_hot(a):
    b = torch.nn.functional.one_hot(a, num_classes=10)
    return b


def print_tensor(x, name):
    max_ = x.max()
    min_ = x.min()
    std_ = x.std()
    mean_ = x.mean()
    print(f"{name}: {max_} {min_} {mean_} {std_}")


def params_count(model):
    """Computes the number of parameters."""
    return sum([p.numel() for p in model.parameters()])

def generate_options(**kargs):
    my_list = []
    for key, value in kargs.items():
        my_list.append(value)
    options = list(itertools.product(*my_list))
    return options
