import pytorch_lightning as pl
import torch
def set_reproducibility(cfg):

    # Setting the seed
    pl.seed_everything(cfg.seed, workers=True)

    # Ensure that all operations are deterministic on GPU (if used) for reproducibility
    if cfg.device != 'cpu':
        torch.backends.cudnn.determinstic = True
        torch.backends.cudnn.benchmark = False