

# ======================= Source code, datasets and preprocessing =======================
# Download the source code and datasets from our codalab worksheet ( XXXX ).
# You should have `CUB_200_2011`, `CUB_processed`, `places365`, `pretrained`, `src` all availble on the path during experiment runs.
# Each python script outputs to a folder, change `-log_dir` or `-out_dir` if you would like different output folders.

# Experiments

## ======================= Main experiments =======================
### Concept Model
python3 src/experiments.py cub Concept_XtoC --seed 1 -ckpt 1 -log_dir ConceptModel__Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck
python3 src/experiments.py cub Concept_XtoC --seed 2 -ckpt 1 -log_dir ConceptModel__Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck
python3 src/experiments.py cub Concept_XtoC --seed 3 -ckpt 1 -log_dir ConceptModel__Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck
python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel__Seed1/outputs/best_model_1.pth --data_dir CUB_processed/class_attr_data_10 --out_dir ConceptModel1__PredConcepts
python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel__Seed2/outputs/best_model_2.pth --data_dir CUB_processed/class_attr_data_10 --out_dir ConceptModel2__PredConcepts
python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel__Seed3/outputs/best_model_3.pth --data_dir CUB_processed/class_attr_data_10 --out_dir ConceptModel3__PredConcepts

### Independent Model
python3 src/experiments.py cub Independent_CtoY --seed 1 -log_dir IndependentModel_WithVal___Seed1/outputs/ -e 500 -optimizer sgd -use_attr -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Independent_CtoY --seed 2 -log_dir IndependentModel_WithVal___Seed2/outputs/ -e 500 -optimizer sgd -use_attr -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Independent_CtoY --seed 3 -log_dir IndependentModel_WithVal___Seed3/outputs/ -e 500 -optimizer sgd -use_attr -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000
python3 src/CUB/inference.py -model_dirs ConceptModel__Seed1/outputs/best_model_1.pth ConceptModel__Seed2/outputs/best_model_2.pth ConceptModel__Seed3/outputs/best_model_3.pth -model_dirs2 IndependentModel_WithVal___Seed1/outputs/best_model_1.pth IndependentModel_WithVal___Seed2/outputs/best_model_2.pth IndependentModel_WithVal___Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck -use_sigmoid -log_dir IndependentModel__WithValSigmoid/outputs

### Sequential Model
python3 src/experiments.py cub Sequential_CtoY --seed 1 -log_dir SequentialModel_WithVal__Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModel1__PredConcepts -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Sequential_CtoY --seed 2 -log_dir SequentialModel_WithVal__Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModel2__PredConcepts -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Sequential_CtoY --seed 3 -log_dir SequentialModel_WithVal__Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModel3__PredConcepts -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000
python3 src/CUB/inference.py -model_dirs ConceptModel__Seed1/outputs/best_model_1.pth ConceptModel__Seed2/outputs/best_model_2.pth ConceptModel__Seed3/outputs/best_model_3.pth -model_dirs2 SequentialModel_WithVal__Seed1/outputs/best_model_1.pth SequentialModel_WithVal__Seed2/outputs/best_model_2.pth SequentialModel_WithVal__Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck -feature_group_results -log_dir SequentialModel__WithVal/outputs

### Standard Model
python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir Joint0Model_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 20 -end2end
python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir Joint0Model_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 20 -end2end
python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir Joint0Model_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 20 -end2end
python3 src/CUB/inference.py -model_dirs Joint0Model_Seed1/outputs/best_model_1.pth Joint0Model_Seed2/outputs/best_model_2.pth Joint0Model_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -log_dir Joint0Model/outputs

### Standard Model Linear Probe
python3 src/CUB/generate_new_data.py ExtractProbeRepresentations --model_path Joint0Model_Seed1/outputs/best_model_1.pth --layer_idx -1 --data_dir CUB_processed/class_attr_data_10 --out_dir Joint0Model_Seed1_ExtractProbeRep
python3 src/CUB/generate_new_data.py ExtractProbeRepresentations --model_path Joint0Model_Seed2/outputs/best_model_2.pth --layer_idx -1 --data_dir CUB_processed/class_attr_data_10 --out_dir Joint0Model_Seed2_ExtractProbeRep
python3 src/CUB/generate_new_data.py ExtractProbeRepresentations --model_path Joint0Model_Seed3/outputs/best_model_3.pth --layer_idx -1 --data_dir CUB_processed/class_attr_data_10 --out_dir Joint0Model_Seed3_ExtractProbeRep
python3 src/CUB/probe.py -data_dir Joint0Model_Seed1_ExtractProbeRep -n_attributes 112 -log_dir Joint0Model_Seed1_LinearProbe/outputs -lr 0.001 -scheduler_step 1000 -weight_decay 0.00004
python3 src/CUB/probe.py -data_dir Joint0Model_Seed2_ExtractProbeRep -n_attributes 112 -log_dir Joint0Model_Seed2_LinearProbe/outputs -lr 0.001 -scheduler_step 1000 -weight_decay 0.00004
python3 src/CUB/probe.py -data_dir Joint0Model_Seed3_ExtractProbeRep -n_attributes 112 -log_dir Joint0Model_Seed3_LinearProbe/outputs -lr 0.001 -scheduler_step 1000 -weight_decay 0.00004
python3 src/CUB/probe.py -data_dirs Joint0Model_Seed1_ExtractProbeRep Joint0Model_Seed2_ExtractProbeRep Joint0Model_Seed3_ExtractProbeRep -log_dir Joint0Model_LinearProbe -eval -model_dirs Joint0Model_Seed1_LinearProbe/outputs/best_model.pth Joint0Model_Seed2_LinearProbe/outputs/best_model.pth Joint0Model_Seed3_LinearProbe/outputs/best_model.pth

### Standard No Bottleneck Model
python3 src/experiments.py cub Standard --seed 1 -ckpt 1 -log_dir StandardNoBNModel_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -data_dir CUB_processed/class_attr_data_10 -b 64 -weight_decay 0.0004 -lr 0.01 -scheduler_step 20
python3 src/experiments.py cub Standard --seed 2 -ckpt 1 -log_dir StandardNoBNModel_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -data_dir CUB_processed/class_attr_data_10 -b 64 -weight_decay 0.0004 -lr 0.01 -scheduler_step 20
python3 src/experiments.py cub Standard --seed 3 -ckpt 1 -log_dir StandardNoBNModel_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -data_dir CUB_processed/class_attr_data_10 -b 64 -weight_decay 0.0004 -lr 0.01 -scheduler_step 20
python3 src/CUB/inference.py -model_dirs StandardNoBNModel_Seed1/outputs/best_model_1.pth StandardNoBNModel_Seed2/outputs/best_model_2.pth StandardNoBNModel_Seed3/outputs/best_model_3.pth -eval_data test -data_dir CUB_processed/class_attr_data_10 -log_dir StandardNoBNModel/outputs

### Joint Model
#### Concept loss weight = 0.001
python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir Joint0.001Model_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.001 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 20 -end2end
python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir Joint0.001Model_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.001 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 20 -end2end
python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir Joint0.001Model_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.001 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 20 -end2end
python3 src/CUB/inference.py -model_dirs Joint0.001Model_Seed1/outputs/best_model_1.pth Joint0.001Model_Seed2/outputs/best_model_2.pth Joint0.001Model_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -log_dir Joint0.001Model/outputs
#### Concept loss weight = 0.01
python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir Joint0.01Model__Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir Joint0.01Model__Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir Joint0.01Model_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -end2end
python3 src/CUB/inference.py -model_dirs Joint0.01Model__Seed1/outputs/best_model_1.pth Joint0.01Model__Seed2/outputs/best_model_2.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -feature_group_results -log_dir Joint0.01Model/outputs
#### Concept loss weight = 0.01, with Sigmoid
python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir Joint0.01SigmoidModel__Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end -use_sigmoid
python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir Joint0.01SigmoidModel__Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end -use_sigmoid
python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir Joint0.01SigmoidModel__Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end -use_sigmoid
#### Concept loss weight = 0.1
python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir Joint0.1Model__Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.1 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir Joint0.1Model__Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.1 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir Joint0.1Model__Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.1 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -end2end
python3 src/CUB/inference.py -model_dirs Joint0.1Model__Seed1/outputs/best_model_1.pth Joint0.1Model__Seed2/outputs/best_model_2.pth Joint0.1Model__Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -log_dir Joint0.1Model/outputs
#### Concept loss weight = 1
python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir Joint1Model__Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 1 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir Joint1Model__Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 1 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir Joint1Model__Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 1 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -end2end
python3 src/CUB/inference.py -model_dirs Joint1Model__Seed1/outputs/best_model_1.pth Joint1Model__Seed2/outputs/best_model_2.pth Joint1Model__Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -log_dir Joint1Model/outputs

### Multitask Model
python3 src/experiments.py cub Multitask --seed 1 -ckpt 1 -log_dir MultitaskModel_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 20
python3 src/experiments.py cub Multitask --seed 2 -ckpt 1 -log_dir MultitaskModel_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 20
python3 src/experiments.py cub Multitask --seed 3 -ckpt 1 -log_dir MultitaskModel_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 20
python3 src/CUB/inference.py -model_dirs MultitaskModel_Seed1/outputs/best_model_1.pth MultitaskModel_Seed2/outputs/best_model_2.pth MultitaskModel_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -log_dir MultitaskModel/outputs

## ======================= Test-time intervention experiments =======================
### Independent Model
python3 src/CUB/tti.py -model_dirs ConceptModel__Seed1/outputs/best_model_1.pth ConceptModel__Seed2/outputs/best_model_2.pth ConceptModel__Seed3/outputs/best_model_3.pth -model_dirs2 IndependentModel_WithVal___Seed1/outputs/best_model_1.pth IndependentModel_WithVal___Seed2/outputs/best_model_2.pth IndependentModel_WithVal___Seed3/outputs/best_model_3.pth -use_attr -bottleneck -mode random -n_trials 5 -use_invisible -class_level -data_dir2 CUB -data_dir CUB_processed/class_attr_data_10 -use_sigmoid -log_dir TTI__IndependentModel_WithValSigmoid

### Sequential Model
python3 src/CUB/tti.py -model_dirs ConceptModel__Seed1/outputs/best_model_1.pth ConceptModel__Seed2/outputs/best_model_2.pth ConceptModel__Seed3/outputs/best_model_3.pth -model_dirs2 SequentialModel_WithVal__Seed1/outputs/best_model_1.pth SequentialModel_WithVal__Seed2/outputs/best_model_2.pth SequentialModel_WithVal__Seed3/outputs/best_model_3.pth -use_attr -bottleneck -mode random -n_trials 5 -use_invisible -class_level -data_dir2 CUB -data_dir CUB_processed/class_attr_data_10 -log_dir TTI__SequentialModel_WithVal

### Joint Model
python3 src/CUB/tti.py -model_dirs Joint0.01SigmoidModel__Seed1/outputs/best_model_1.pth Joint0.01SigmoidModel__Seed2/outputs/best_model_2.pth Joint0.01SigmoidModel__Seed3/outputs/best_model_3.pth -use_sigmoid -use_attr -mode random -n_trials 5 -use_invisible -class_level -data_dir2 CUB -data_dir CUB_processed/class_attr_data_10 -log_dir TTI__Joint0.01SigmoidModel
python3 src/CUB/tti.py -model_dirs Joint0.01Model__Seed1/outputs/best_model_1.pth Joint0.01Model__Seed2/outputs/best_model_2.pth -use_attr -mode random -n_trials 5 -use_invisible -class_level -data_dir2 CUB -data_dir CUB_processed/class_attr_data_10 -log_dir TTI__Joint0.01Model

## ======================= Robustness experiments =======================
### Generate Adversarial Data
python3 src/CUB/gen_cub_synthetic.py --cub_dir CUB_200_2011 --places_dir places365 --out_dir AdversarialData

### Concept Model
python3 src/CUB/generate_new_data.py ChangeAdversarialDataDir --adv_data_dir AdversarialData/CUB_fixed --train_splits train val --data_dir CUB_processed/class_attr_data_10 --out_dir ConceptAdversarialModel1_ChangeDir_Train/masked_datasets/
python3 src/CUB/generate_new_data.py ChangeAdversarialDataDir --adv_data_dir AdversarialData/CUB_fixed --train_splits train val --data_dir CUB_processed/class_attr_data_10 --out_dir ConceptAdversarialModel2_ChangeDir_Train/masked_datasets/
python3 src/CUB/generate_new_data.py ChangeAdversarialDataDir --adv_data_dir AdversarialData/CUB_fixed --train_splits train val --data_dir CUB_processed/class_attr_data_10 --out_dir ConceptAdversarialModel3_ChangeDir_Train/masked_datasets/
python3 src/experiments.py cub Concept_XtoC --seed 1 -ckpt 1 -log_dir ConceptAdversarialModel__Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck -image_dir AdversarialData/CUB_fixed/train
python3 src/experiments.py cub Concept_XtoC --seed 2 -ckpt 1 -log_dir ConceptAdversarialModel__Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck -image_dir AdversarialData/CUB_fixed/train
python3 src/experiments.py cub Concept_XtoC --seed 3 -ckpt 1 -log_dir ConceptAdversarialModel__Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck -image_dir AdversarialData/CUB_fixed/train
python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptAdversarialModel__Seed1/outputs/best_model_1.pth --data_dir ConceptAdversarialModel1_ChangeDir_Train/masked_datasets --out_dir ConceptAdversarialModel1__PredConcepts
python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptAdversarialModel__Seed2/outputs/best_model_2.pth --data_dir ConceptAdversarialModel2_ChangeDir_Train/masked_datasets --out_dir ConceptAdversarialModel2__PredConcepts
python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptAdversarialModel__Seed3/outputs/best_model_3.pth --data_dir ConceptAdversarialModel3_ChangeDir_Train/masked_datasets --out_dir ConceptAdversarialModel3__PredConcepts

### Independent Model
python3 src/experiments.py cub Independent_CtoY --seed 1 -log_dir IndependentAdversarialSigmoidModel__Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000 -image_dir AdversarialData/CUB_fixed/train -use_sigmoid
python3 src/experiments.py cub Independent_CtoY --seed 2 -log_dir IndependentAdversarialSigmoidModel__Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000 -image_dir AdversarialData/CUB_fixed/train -use_sigmoid
python3 src/experiments.py cub Independent_CtoY --seed 3 -log_dir IndependentAdversarialSigmoidModel__Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000 -image_dir AdversarialData/CUB_fixed/train -use_sigmoid
python3 src/CUB/inference.py -model_dirs ConceptAdversarialModel__Seed1/outputs/best_model_1.pth ConceptAdversarialModel__Seed2/outputs/best_model_2.pth ConceptAdversarialModel__Seed3/outputs/best_model_3.pth -model_dirs2 IndependentAdversarialSigmoidModel__Seed1/outputs/best_model_1.pth IndependentAdversarialSigmoidModel__Seed2/outputs/best_model_2.pth IndependentAdversarialSigmoidModel__Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck -image_dir AdversarialData/CUB_fixed/test/ -use_sigmoid -log_dir IndependentAdversarialSigmoidModel/outputs

### Sequential Model
python3 src/experiments.py cub Sequential_CtoY --seed 1 -log_dir SequentialAdversarialModel__Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptAdversarialModel1__PredConcepts -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000 -image_dir AdversarialData/CUB_fixed/train
python3 src/experiments.py cub Sequential_CtoY --seed 2 -log_dir SequentialAdversarialModel__Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptAdversarialModel2__PredConcepts -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000 -image_dir AdversarialData/CUB_fixed/train
python3 src/experiments.py cub Sequential_CtoY --seed 3 -log_dir SequentialAdversarialModel__Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptAdversarialModel3__PredConcepts -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000 -image_dir AdversarialData/CUB_fixed/train
python3 src/CUB/inference.py -model_dirs ConceptAdversarialModel__Seed1/outputs/best_model_1.pth ConceptAdversarialModel__Seed2/outputs/best_model_2.pth ConceptAdversarialModel__Seed3/outputs/best_model_3.pth -model_dirs2 SequentialAdversarialModel__Seed1/outputs/best_model_1.pth SequentialAdversarialModel__Seed2/outputs/best_model_2.pth SequentialAdversarialModel__Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck -image_dir AdversarialData/CUB_fixed/test/ -log_dir SequentialAdversarialModel/outputs

### Standard Model
python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir Joint0AdversarialModel__Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end -image_dir AdversarialData/CUB_fixed/train
python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir Joint0AdversarialModel__Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end -image_dir AdversarialData/CUB_fixed/train
python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir Joint0AdversarialModel__Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end -image_dir AdversarialData/CUB_fixed/train
python3 src/CUB/inference.py -model_dirs Joint0AdversarialModel__Seed1/outputs/best_model_1.pth Joint0AdversarialModel__Seed2/outputs/best_model_2.pth Joint0AdversarialModel__Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -image_dir AdversarialData/CUB_fixed/test/ -log_dir Joint0AdversarialModel/outputs

### Joint Model
python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir Joint0.01AdversarialModel__Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end -image_dir AdversarialData/CUB_fixed/train
python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir Joint0.01AdversarialModel__Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end -image_dir AdversarialData/CUB_fixed/train
python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir Joint0.01AdversarialModel__Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end -image_dir AdversarialData/CUB_fixed/train
python3 src/CUB/inference.py -model_dirs Joint0.01AdversarialModel__Seed1/outputs/best_model_1.pth Joint0.01AdversarialModel__Seed2/outputs/best_model_2.pth Joint0.01AdversarialModel__Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -image_dir AdversarialData/CUB_fixed/test/ -log_dir Joint0.01AdversarialModel/outputs

## ======================= Data efficiency experiments =======================
### Generate Data Splits
python3 src/CUB/generate_new_data.py DataEfficiencySplits --n_samples 1 --out_dir DataEfficiencySplits_N1 --splits_dir CUB_processed/class_attr_data_10
python3 src/CUB/generate_new_data.py DataEfficiencySplits --n_samples 3 --out_dir DataEfficiencySplits_N3 --splits_dir CUB_processed/class_attr_data_10
python3 src/CUB/generate_new_data.py DataEfficiencySplits --n_samples 7 --out_dir DataEfficiencySplits_N7 --splits_dir CUB_processed/class_attr_data_10
python3 src/CUB/generate_new_data.py DataEfficiencySplits --n_samples 10 --out_dir DataEfficiencySplits_N10 --splits_dir CUB_processed/class_attr_data_10
python3 src/CUB/generate_new_data.py DataEfficiencySplits --n_samples 15 --out_dir DataEfficiencySplits_N15 --splits_dir CUB_processed/class_attr_data_10

### Concept Model
python3 src/experiments.py cub Concept_XtoC --seed 1 -ckpt 1 -log_dir ConceptModel_DataEffN1_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N1 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck
python3 src/experiments.py cub Concept_XtoC --seed 2 -ckpt 1 -log_dir ConceptModel_DataEffN1_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N1 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck
python3 src/experiments.py cub Concept_XtoC --seed 3 -ckpt 1 -log_dir ConceptModel_DataEffN1_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N1 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck
python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN1_Seed1/outputs/best_model_1.pth --data_dir DataEfficiencySplits_N1 --out_dir ConceptModelDataEffN1_PredConcepts1
python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN1_Seed2/outputs/best_model_2.pth --data_dir DataEfficiencySplits_N1 --out_dir ConceptModelDataEffN1_PredConcepts2
python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN1_Seed3/outputs/best_model_3.pth --data_dir DataEfficiencySplits_N1 --out_dir ConceptModelDataEffN1_PredConcepts3
python3 src/experiments.py cub Concept_XtoC --seed 1 -ckpt 1 -log_dir ConceptModel_DataEffN3_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N3 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck
python3 src/experiments.py cub Concept_XtoC --seed 2 -ckpt 1 -log_dir ConceptModel_DataEffN3_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N3 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck
python3 src/experiments.py cub Concept_XtoC --seed 3 -ckpt 1 -log_dir ConceptModel_DataEffN3_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N3 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck
python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN3_Seed1/outputs/best_model_1.pth --data_dir DataEfficiencySplits_N3 --out_dir ConceptModelDataEffN3_PredConcepts1
python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN3_Seed2/outputs/best_model_2.pth --data_dir DataEfficiencySplits_N3 --out_dir ConceptModelDataEffN3_PredConcepts2
python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN3_Seed3/outputs/best_model_3.pth --data_dir DataEfficiencySplits_N3 --out_dir ConceptModelDataEffN3_PredConcepts3
python3 src/experiments.py cub Concept_XtoC --seed 1 -ckpt 1 -log_dir ConceptModel_DataEffN7_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N7 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck
python3 src/experiments.py cub Concept_XtoC --seed 2 -ckpt 1 -log_dir ConceptModel_DataEffN7_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N7 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck
python3 src/experiments.py cub Concept_XtoC --seed 3 -ckpt 1 -log_dir ConceptModel_DataEffN7_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N7 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck
python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN7_Seed1/outputs/best_model_1.pth --data_dir DataEfficiencySplits_N7 --out_dir ConceptModelDataEffN7_PredConcepts1
python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN7_Seed2/outputs/best_model_2.pth --data_dir DataEfficiencySplits_N7 --out_dir ConceptModelDataEffN7_PredConcepts2
python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN7_Seed3/outputs/best_model_3.pth --data_dir DataEfficiencySplits_N7 --out_dir ConceptModelDataEffN7_PredConcepts3
python3 src/experiments.py cub Concept_XtoC --seed 1 -ckpt 1 -log_dir ConceptModel_DataEffN10_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N10 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck
python3 src/experiments.py cub Concept_XtoC --seed 2 -ckpt 1 -log_dir ConceptModel_DataEffN10_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N10 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck
python3 src/experiments.py cub Concept_XtoC --seed 3 -ckpt 1 -log_dir ConceptModel_DataEffN10_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N10 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck
python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN10_Seed1/outputs/best_model_1.pth --data_dir DataEfficiencySplits_N10 --out_dir ConceptModelDataEffN10_PredConcepts1
python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN10_Seed2/outputs/best_model_2.pth --data_dir DataEfficiencySplits_N10 --out_dir ConceptModelDataEffN10_PredConcepts2
python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN10_Seed3/outputs/best_model_3.pth --data_dir DataEfficiencySplits_N10 --out_dir ConceptModelDataEffN10_PredConcepts3
python3 src/experiments.py cub Concept_XtoC --seed 1 -ckpt 1 -log_dir ConceptModel_DataEffN15_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N15 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck
python3 src/experiments.py cub Concept_XtoC --seed 2 -ckpt 1 -log_dir ConceptModel_DataEffN15_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N15 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck
python3 src/experiments.py cub Concept_XtoC --seed 3 -ckpt 1 -log_dir ConceptModel_DataEffN15_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N15 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck
python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN15_Seed1/outputs/best_model_1.pth --data_dir DataEfficiencySplits_N15 --out_dir ConceptModelDataEffN15_PredConcepts1
python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN15_Seed2/outputs/best_model_2.pth --data_dir DataEfficiencySplits_N15 --out_dir ConceptModelDataEffN15_PredConcepts2
python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN15_Seed3/outputs/best_model_3.pth --data_dir DataEfficiencySplits_N15 --out_dir ConceptModelDataEffN15_PredConcepts3

### Independent Model
python3 src/experiments.py cub Independent_CtoY --seed 1 -log_dir IndependentModel_WithVal_DataEffN1_Seed1/outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N1 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Independent_CtoY --seed 2 -log_dir IndependentModel_WithVal_DataEffN1_Seed2/outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N1 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Independent_CtoY --seed 3 -log_dir IndependentModel_WithVal_DataEffN1_Seed3/outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N1 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Independent_CtoY --seed 1 -log_dir IndependentModel_WithVal_DataEffN3_Seed1/outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N3 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Independent_CtoY --seed 2 -log_dir IndependentModel_WithVal_DataEffN3_Seed2/outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N3 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Independent_CtoY --seed 3 -log_dir IndependentModel_WithVal_DataEffN3_Seed3/outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N3 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Independent_CtoY --seed 2 -log_dir IndependentModel_WithVal_DataEffN3_Seed2/outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N3 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Independent_CtoY --seed 3 -log_dir IndependentModel_WithVal_DataEffN3_Seed3/outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N3 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Independent_CtoY --seed 1 -log_dir IndependentModel_WithVal_DataEffN10_Seed1/outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N10 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Independent_CtoY --seed 2 -log_dir IndependentModel_WithVal_DataEffN10_Seed2/outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N10 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Independent_CtoY --seed 3 -log_dir IndependentModel_WithVal_DataEffN10_Seed3/outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N10 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Independent_CtoY --seed 1 -log_dir IndependentModel_WithVal_DataEffN15_Seed1/outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N15 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Independent_CtoY --seed 2 -log_dir IndependentModel_WithVal_DataEffN15_Seed2/outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N15 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Independent_CtoY --seed 3 -log_dir IndependentModel_WithVal_DataEffN15_Seed3/outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N15 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000

python3 src/CUB/inference.py -model_dirs ConceptModel_DataEffN1_Seed1/outputs/best_model_1.pth ConceptModel_DataEffN1_Seed2/outputs/best_model_2.pth ConceptModel_DataEffN1_Seed3/outputs/best_model_3.pth -model_dirs2 IndependentModel_WithVal_DataEffN1_Seed1/outputs/best_model_1.pth IndependentModel_WithVal_DataEffN1_Seed2/outputs/best_model_2.pth IndependentModel_WithVal_DataEffN1_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck -use_sigmoid -log_dir IndependentModel_WithVal_DataEffN1_Result/outputs
python3 src/CUB/inference.py -model_dirs ConceptModel_DataEffN3_Seed1/outputs/best_model_1.pth ConceptModel_DataEffN3_Seed2/outputs/best_model_2.pth ConceptModel_DataEffN3_Seed3/outputs/best_model_3.pth -model_dirs2 IndependentModel_WithVal_DataEffN3_Seed1/outputs/best_model_1.pth IndependentModel_WithVal_DataEffN3_Seed2/outputs/best_model_2.pth IndependentModel_WithVal_DataEffN3_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck -use_sigmoid -log_dir IndependentModel_WithVal_DataEffN3_Result/outputs
python3 src/CUB/inference.py -model_dirs ConceptModel_DataEffN7_Seed1/outputs/best_model_1.pth ConceptModel_DataEffN7_Seed2/outputs/best_model_2.pth ConceptModel_DataEffN7_Seed3/outputs/best_model_3.pth -model_dirs2 IndependentModel_WithVal_DataEffN7_Seed1/outputs/best_model_1.pth IndependentModel_WithVal_DataEffN7_Seed2/outputs/best_model_2.pth IndependentModel_WithVal_DataEffN7_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck -use_sigmoid -log_dir IndependentModel_WithVal_DataEffN7_Result/outputs
python3 src/CUB/inference.py -model_dirs ConceptModel_DataEffN10_Seed1/outputs/best_model_1.pth ConceptModel_DataEffN10_Seed2/outputs/best_model_2.pth ConceptModel_DataEffN10_Seed3/outputs/best_model_3.pth -model_dirs2 IndependentModel_WithVal_DataEffN10_Seed1/outputs/best_model_1.pth IndependentModel_WithVal_DataEffN10_Seed2/outputs/best_model_2.pth IndependentModel_WithVal_DataEffN10_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck -use_sigmoid -log_dir IndependentModel_WithVal_DataEffN10_Result/outputs
python3 src/CUB/inference.py -model_dirs ConceptModel_DataEffN15_Seed1/outputs/best_model_1.pth ConceptModel_DataEffN15_Seed2/outputs/best_model_2.pth ConceptModel_DataEffN15_Seed3/outputs/best_model_3.pth -model_dirs2 IndependentModel_WithVal_DataEffN15_Seed1/outputs/best_model_1.pth IndependentModel_WithVal_DataEffN15_Seed2/outputs/best_model_2.pth IndependentModel_WithVal_DataEffN15_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck -use_sigmoid -log_dir IndependentModel_WithVal_DataEffN15_Result/outputs

### Sequential Model
python3 src/experiments.py cub Sequential_CtoY --seed 1 -log_dir SequentialModel_WithVal_DataEffN1_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN1_PredConcepts1 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Sequential_CtoY --seed 2 -log_dir SequentialModel_WithVal_DataEffN1_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN1_PredConcepts2 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Sequential_CtoY --seed 3 -log_dir SequentialModel_WithVal_DataEffN1_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN1_PredConcepts3 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Sequential_CtoY --seed 1 -log_dir SequentialModel_WithVal_DataEffN3_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN3_PredConcepts1 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Sequential_CtoY --seed 2 -log_dir SequentialModel_WithVal_DataEffN3_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN3_PredConcepts2 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Sequential_CtoY --seed 3 -log_dir SequentialModel_WithVal_DataEffN3_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN3_PredConcepts3 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Sequential_CtoY --seed 1 -log_dir SequentialModel_WithVal_DataEffN7_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN7_PredConcepts1 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Sequential_CtoY --seed 2 -log_dir SequentialModel_WithVal_DataEffN7_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN7_PredConcepts2 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Sequential_CtoY --seed 3 -log_dir SequentialModel_WithVal_DataEffN7_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN7_PredConcepts3 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Sequential_CtoY --seed 1 -log_dir SequentialModel_WithVal_DataEffN10_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN10_PredConcepts1 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Sequential_CtoY --seed 2 -log_dir SequentialModel_WithVal_DataEffN10_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN10_PredConcepts2 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Sequential_CtoY --seed 3 -log_dir SequentialModel_WithVal_DataEffN10_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN10_PredConcepts3 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Sequential_CtoY --seed 1 -log_dir SequentialModel_WithVal_DataEffN10_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN10_PredConcepts1 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Sequential_CtoY --seed 2 -log_dir SequentialModel_WithVal_DataEffN10_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN10_PredConcepts2 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Sequential_CtoY --seed 3 -log_dir SequentialModel_WithVal_DataEffN10_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN10_PredConcepts3 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Sequential_CtoY --seed 1 -log_dir SequentialModel_WithVal_DataEffN15_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN15_PredConcepts1 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Sequential_CtoY --seed 2 -log_dir SequentialModel_WithVal_DataEffN15_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN15_PredConcepts2 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000
python3 src/experiments.py cub Sequential_CtoY --seed 3 -log_dir SequentialModel_WithVal_DataEffN15_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN15_PredConcepts3 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000

python3 src/CUB/inference.py -model_dirs ConceptModel_DataEffN1_Seed1/outputs/best_model_1.pth ConceptModel_DataEffN1_Seed2/outputs/best_model_2.pth ConceptModel_DataEffN1_Seed3/outputs/best_model_3.pth -model_dirs2 SequentialModel_WithVal_DataEffN1_Seed1/outputs/best_model_1.pth SequentialModel_WithVal_DataEffN1_Seed2/outputs/best_model_2.pth SequentialModel_WithVal_DataEffN1_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck -log_dir SequentialModel_WithVal_DataEffN1_Result/outputs
python3 src/CUB/inference.py -model_dirs ConceptModel_DataEffN3_Seed1/outputs/best_model_1.pth ConceptModel_DataEffN3_Seed2/outputs/best_model_2.pth ConceptModel_DataEffN3_Seed3/outputs/best_model_3.pth -model_dirs2 SequentialModel_WithVal_DataEffN3_Seed1/outputs/best_model_1.pth SequentialModel_WithVal_DataEffN3_Seed2/outputs/best_model_2.pth SequentialModel_WithVal_DataEffN3_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck -log_dir SequentialModel_WithVal_DataEffN3_Result/outputs
python3 src/CUB/inference.py -model_dirs ConceptModel_DataEffN7_Seed1/outputs/best_model_1.pth ConceptModel_DataEffN7_Seed2/outputs/best_model_2.pth ConceptModel_DataEffN7_Seed3/outputs/best_model_3.pth -model_dirs2 SequentialModel_WithVal_DataEffN7_Seed1/outputs/best_model_1.pth SequentialModel_WithVal_DataEffN7_Seed2/outputs/best_model_2.pth SequentialModel_WithVal_DataEffN7_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck -log_dir SequentialModel_WithVal_DataEffN7_Result/outputs
python3 src/CUB/inference.py -model_dirs ConceptModel_DataEffN10_Seed1/outputs/best_model_1.pth ConceptModel_DataEffN10_Seed2/outputs/best_model_2.pth ConceptModel_DataEffN10_Seed3/outputs/best_model_3.pth -model_dirs2 SequentialModel_WithVal_DataEffN10_Seed1/outputs/best_model_1.pth SequentialModel_WithVal_DataEffN10_Seed2/outputs/best_model_2.pth SequentialModel_WithVal_DataEffN10_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck -log_dir SequentialModel_WithVal_DataEffN10_Result/outputs
python3 src/CUB/inference.py -model_dirs ConceptModel_DataEffN15_Seed1/outputs/best_model_1.pth ConceptModel_DataEffN15_Seed2/outputs/best_model_2.pth ConceptModel_DataEffN15_Seed3/outputs/best_model_3.pth -model_dirs2 SequentialModel_WithVal_DataEffN15_Seed1/outputs/best_model_1.pth SequentialModel_WithVal_DataEffN15_Seed2/outputs/best_model_2.pth SequentialModel_WithVal_DataEffN15_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck -log_dir SequentialModel_WithVal_DataEffN15_Result/outputs

### Standard Model
python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir Joint0Model_DataEffN1_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N1 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir Joint0Model_DataEffN1_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N1 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir Joint0Model_DataEffN1_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N1 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir Joint0Model_DataEffN3_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N3 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir Joint0Model_DataEffN3_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N3 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir Joint0Model_DataEffN3_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N3 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir Joint0Model_DataEffN7_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N7 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir Joint0Model_DataEffN7_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N7 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir Joint0Model_DataEffN7_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N7 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir Joint0Model_DataEffN10_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N10 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir Joint0Model_DataEffN10_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N10 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir Joint0Model_DataEffN10_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N10 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir Joint0Model_DataEffN15_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N15 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir Joint0Model_DataEffN15_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N15 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir Joint0Model_DataEffN15_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N15 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end

python3 src/CUB/inference.py -model_dirs Joint0Model_DataEffN1_Seed1/outputs/best_model_1.pth Joint0Model_DataEffN1_Seed2/outputs/best_model_2.pth Joint0Model_DataEffN1_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -log_dir Joint0Model_DataEffN1_Result/outputs
python3 src/CUB/inference.py -model_dirs Joint0Model_DataEffN3_Seed1/outputs/best_model_1.pth Joint0Model_DataEffN3_Seed2/outputs/best_model_2.pth Joint0Model_DataEffN3_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -log_dir Joint0Model_DataEffN3_Result/outputs
python3 src/CUB/inference.py -model_dirs Joint0Model_DataEffN7_Seed1/outputs/best_model_1.pth Joint0Model_DataEffN7_Seed2/outputs/best_model_2.pth Joint0Model_DataEffN7_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -log_dir Joint0Model_DataEffN7_Result/outputs
python3 src/CUB/inference.py -model_dirs Joint0Model_DataEffN10_Seed1/outputs/best_model_1.pth Joint0Model_DataEffN10_Seed2/outputs/best_model_2.pth Joint0Model_DataEffN10_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -log_dir Joint0Model_DataEffN10_Result/outputs
python3 src/CUB/inference.py -model_dirs Joint0Model_DataEffN15_Seed1/outputs/best_model_1.pth Joint0Model_DataEffN15_Seed2/outputs/best_model_2.pth Joint0Model_DataEffN15_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -log_dir Joint0Model_DataEffN15_Result/outputs

### Joint Model
python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir Joint0.01Model_DataEffN1_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N1 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir Joint0.01Model_DataEffN1_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N1 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir Joint0.01Model_DataEffN1_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N1 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir Joint0.01Model_DataEffN3_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N3 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir Joint0.01Model_DataEffN3_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N3 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir Joint0.01Model_DataEffN3_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N3 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir Joint0.01Model_DataEffN7_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N7 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir Joint0.01Model_DataEffN7_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N7 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir Joint0.01Model_DataEffN7_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N7 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir Joint0.01Model_DataEffN10_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir Joint0.01Model_DataEffN10_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir Joint0.01Model_DataEffN10_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir Joint0.01Model_DataEffN10_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir Joint0.01Model_DataEffN10_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir Joint0.01Model_DataEffN10_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir Joint0.01Model_DataEffN15_Seed1/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N15 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir Joint0.01Model_DataEffN15_Seed2/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N15 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end
python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir Joint0.01Model_DataEffN15_Seed3/outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N15 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end

python3 src/CUB/inference.py -model_dirs Joint0.01Model_DataEffN1_Seed1/outputs/best_model_1.pth Joint0.01Model_DataEffN1_Seed2/outputs/best_model_2.pth Joint0.01Model_DataEffN1_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -log_dir Joint0.01Model_DataEffN1_Result/outputs
python3 src/CUB/inference.py -model_dirs Joint0.01Model_DataEffN3_Seed1/outputs/best_model_1.pth Joint0.01Model_DataEffN3_Seed2/outputs/best_model_2.pth Joint0.01Model_DataEffN3_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -log_dir Joint0.01Model_DataEffN3_Result/outputs
python3 src/CUB/inference.py -model_dirs Joint0.01Model_DataEffN7_Seed1/outputs/best_model_1.pth Joint0.01Model_DataEffN7_Seed2/outputs/best_model_2.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -log_dir Joint0.01Model_DataEffN7_Result/outputs
python3 src/CUB/inference.py -model_dirs Joint0.01Model_DataEffN10_Seed1/outputs/best_model_1.pth Joint0.01Model_DataEffN10_Seed2/outputs/best_model_2.pth Joint0.01Model_DataEffN10_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -log_dir Joint0.01Model_DataEffN10_Result/outputs
python3 src/CUB/inference.py -model_dirs Joint0.01Model_DataEffN15_Seed1/outputs/best_model_1.pth Joint0.01Model_DataEffN15_Seed2/outputs/best_model_2.pth Joint0.01Model_DataEffN15_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -log_dir Joint0.01Model_DataEffN15_Result/outputs

# ======================= Figures =======================
python3 src/CUB/plots.py
