

# Source code, datasets and preprocessing
#### Upload the source code and datasets from our codalab worksheet ( XXXX ).

# Experiments

## ======================= Main experiments =======================
### Concept Model
cl run -n ConceptModel__Seed1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Concept_XtoC --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck'
cl run -n ConceptModel__Seed2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Concept_XtoC --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck'
cl run -n ConceptModel__Seed3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Concept_XtoC --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck'
cl run -n ConceptModel1__PredConcepts --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained :ConceptModel__Seed1 'python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel__Seed1/outputs/best_model_1.pth --data_dir CUB_processed/class_attr_data_10 --out_dir .'
cl run -n ConceptModel2__PredConcepts --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained :ConceptModel__Seed2 'python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel__Seed2/outputs/best_model_2.pth --data_dir CUB_processed/class_attr_data_10 --out_dir .'
cl run -n ConceptModel3__PredConcepts --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained :ConceptModel__Seed3 'python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel__Seed3/outputs/best_model_3.pth --data_dir CUB_processed/class_attr_data_10 --out_dir .'

### Independent Model
cl run -n IndependentModel_WithVal___Seed1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Independent_CtoY --seed 1 -log_dir outputs/ -e 500 -optimizer sgd -use_attr -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000'
cl run -n IndependentModel_WithVal___Seed2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Independent_CtoY --seed 2 -log_dir outputs/ -e 500 -optimizer sgd -use_attr -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000'
cl run -n IndependentModel_WithVal___Seed3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Independent_CtoY --seed 3 -log_dir outputs/ -e 500 -optimizer sgd -use_attr -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000'
cl run -n IndependentModel__WithValSigmoid --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :ConceptModel__Seed1 :ConceptModel__Seed2 :ConceptModel__Seed3 :IndependentModel_WithVal___Seed1 :IndependentModel_WithVal___Seed2 :IndependentModel_WithVal___Seed3 'python3 src/CUB/inference.py -model_dirs ConceptModel__Seed1/outputs/best_model_1.pth ConceptModel__Seed2/outputs/best_model_2.pth ConceptModel__Seed3/outputs/best_model_3.pth -model_dirs2 IndependentModel_WithVal___Seed1/outputs/best_model_1.pth IndependentModel_WithVal___Seed2/outputs/best_model_2.pth IndependentModel_WithVal___Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck -use_sigmoid'

### Sequential Model
cl run -n SequentialModel_WithVal__Seed1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained :ConceptModel1__PredConcepts 'python3 src/experiments.py cub Sequential_CtoY --seed 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModel1__PredConcepts -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000'
cl run -n SequentialModel_WithVal__Seed2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained :ConceptModel2__PredConcepts 'python3 src/experiments.py cub Sequential_CtoY --seed 2 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModel2__PredConcepts -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000'
cl run -n SequentialModel_WithVal__Seed3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained :ConceptModel3__PredConcepts 'python3 src/experiments.py cub Sequential_CtoY --seed 3 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModel3__PredConcepts -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000'
cl run -n SequentialModel__WithVal --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :ConceptModel__Seed1 :ConceptModel__Seed2 :ConceptModel__Seed3 :SequentialModel_WithVal__Seed1 :SequentialModel_WithVal__Seed2 :SequentialModel_WithVal__Seed3 'python3 src/CUB/inference.py -model_dirs ConceptModel__Seed1/outputs/best_model_1.pth ConceptModel__Seed2/outputs/best_model_2.pth ConceptModel__Seed3/outputs/best_model_3.pth -model_dirs2 SequentialModel_WithVal__Seed1/outputs/best_model_1.pth SequentialModel_WithVal__Seed2/outputs/best_model_2.pth SequentialModel_WithVal__Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck -feature_group_results'

### Standard Model
cl run -n Joint0Model_Seed1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 20 -end2end'
cl run -n Joint0Model_Seed2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 20 -end2end'
cl run -n Joint0Model_Seed3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 20 -end2end'
cl run -n Joint0Model --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :Joint0Model_Seed1 :Joint0Model_Seed2 :Joint0Model_Seed3 'python3 src/CUB/inference.py -model_dirs Joint0Model_Seed1/outputs/best_model_1.pth Joint0Model_Seed2/outputs/best_model_2.pth Joint0Model_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10'

### Standard Model Linear Probe
cl run -n Joint0Model_Seed1_ExtractProbeRep --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained :Joint0Model_Seed1 'python3 src/CUB/generate_new_data.py ExtractProbeRepresentations --model_path Joint0Model_Seed1/outputs/best_model_1.pth --layer_idx -1 --data_dir CUB_processed/class_attr_data_10 --out_dir .'
cl run -n Joint0Model_Seed2_ExtractProbeRep --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained :Joint0Model_Seed2 'python3 src/CUB/generate_new_data.py ExtractProbeRepresentations --model_path Joint0Model_Seed2/outputs/best_model_2.pth --layer_idx -1 --data_dir CUB_processed/class_attr_data_10 --out_dir .'
cl run -n Joint0Model_Seed3_ExtractProbeRep --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained :Joint0Model_Seed3 'python3 src/CUB/generate_new_data.py ExtractProbeRepresentations --model_path Joint0Model_Seed3/outputs/best_model_3.pth --layer_idx -1 --data_dir CUB_processed/class_attr_data_10 --out_dir .'
cl run -n Joint0Model_Seed1_LinearProbe --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained :Joint0Model_Seed1_ExtractProbeRep 'python3 src/CUB/probe.py -data_dir Joint0Model_Seed1_ExtractProbeRep -n_attributes 112 -log_dir outputs -lr 0.001 -scheduler_step 1000 -weight_decay 0.00004'
cl run -n Joint0Model_Seed2_LinearProbe --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained :Joint0Model_Seed2_ExtractProbeRep 'python3 src/CUB/probe.py -data_dir Joint0Model_Seed2_ExtractProbeRep -n_attributes 112 -log_dir outputs -lr 0.001 -scheduler_step 1000 -weight_decay 0.00004'
cl run -n Joint0Model_Seed3_LinearProbe --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained :Joint0Model_Seed3_ExtractProbeRep 'python3 src/CUB/probe.py -data_dir Joint0Model_Seed3_ExtractProbeRep -n_attributes 112 -log_dir outputs -lr 0.001 -scheduler_step 1000 -weight_decay 0.00004'
cl run -n Joint0Model_LinearProbe --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained :Joint0Model_Seed1_ExtractProbeRep :Joint0Model_Seed2_ExtractProbeRep :Joint0Model_Seed3_ExtractProbeRep :Joint0Model_Seed1_LinearProbe :Joint0Model_Seed2_LinearProbe :Joint0Model_Seed3_LinearProbe 'python3 src/CUB/probe.py -data_dirs Joint0Model_Seed1_ExtractProbeRep Joint0Model_Seed2_ExtractProbeRep Joint0Model_Seed3_ExtractProbeRep -eval -model_dirs Joint0Model_Seed1_LinearProbe/outputs/best_model.pth Joint0Model_Seed2_LinearProbe/outputs/best_model.pth Joint0Model_Seed3_LinearProbe/outputs/best_model.pth'

### Standard No Bottleneck Model
cl run -n StandardNoBNModel_Seed1 --request-memory 4g --request-gpus 1 :src,places365: :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Standard --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -data_dir CUB_processed/class_attr_data_10 -b 64 -weight_decay 0.0004 -lr 0.01 -scheduler_step 20'
cl run -n StandardNoBNModel_Seed2 --request-memory 4g --request-gpus 1 :src,places365: :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Standard --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -data_dir CUB_processed/class_attr_data_10 -b 64 -weight_decay 0.0004 -lr 0.01 -scheduler_step 20'
cl run -n StandardNoBNModel_Seed3 --request-memory 4g --request-gpus 1 :src,places365: :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Standard --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -data_dir CUB_processed/class_attr_data_10 -b 64 -weight_decay 0.0004 -lr 0.01 -scheduler_step 20'
cl run -n StandardNoBNModel --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :StandardNoBNModel_Seed1 :StandardNoBNModel_Seed2 :StandardNoBNModel_Seed3 'python3 src/CUB/inference.py -model_dirs StandardNoBNModel_Seed1/outputs/best_model_1.pth StandardNoBNModel_Seed2/outputs/best_model_2.pth StandardNoBNModel_Seed3/outputs/best_model_3.pth -eval_data test -data_dir CUB_processed/class_attr_data_10'

### Joint Model
#### Concept loss weight = 0.001
cl run -n Joint0.001Model_Seed1 --request-memory 4g --request-gpus 1 :src,places365: :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.001 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 20 -end2end'
cl run -n Joint0.001Model_Seed2 --request-memory 4g --request-gpus 1 :src,places365: :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.001 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 20 -end2end'
cl run -n Joint0.001Model_Seed3 --request-memory 4g --request-gpus 1 :src,places365: :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.001 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 20 -end2end'
cl run -n Joint0.001Model --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :Joint0.001Model_Seed1 :Joint0.001Model_Seed2 :Joint0.001Model_Seed3 'python3 src/CUB/inference.py -model_dirs Joint0.001Model_Seed1/outputs/best_model_1.pth Joint0.001Model_Seed2/outputs/best_model_2.pth Joint0.001Model_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10'
#### Concept loss weight = 0.01
cl run -n Joint0.01Model__Seed1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0.01Model__Seed2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0.01Model_Seed3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 20 -end2end'
cl run -n Joint0.01Model --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :Joint0.01Model__Seed1 :Joint0.01Model__Seed2 'python3 src/CUB/inference.py -model_dirs Joint0.01Model__Seed1/outputs/best_model_1.pth Joint0.01Model__Seed2/outputs/best_model_2.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -feature_group_results'
#### Concept loss weight = 0.01, with Sigmoid
cl run -n Joint0.01SigmoidModel__Seed1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end -use_sigmoid'
cl run -n Joint0.01SigmoidModel__Seed2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end -use_sigmoid'
cl run -n Joint0.01SigmoidModel__Seed3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end -use_sigmoid'
#### Concept loss weight = 0.1
cl run -n Joint0.1Model__Seed1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.1 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -end2end'
cl run -n Joint0.1Model__Seed2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.1 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -end2end'
cl run -n Joint0.1Model__Seed3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.1 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -end2end'
cl run -n Joint0.1Model --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :Joint0.1Model__Seed1 :Joint0.1Model__Seed2 :Joint0.1Model__Seed3 'python3 src/CUB/inference.py -model_dirs Joint0.1Model__Seed1/outputs/best_model_1.pth Joint0.1Model__Seed2/outputs/best_model_2.pth Joint0.1Model__Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10'
#### Concept loss weight = 1
cl run -n Joint1Model__Seed1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 1 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -end2end'
cl run -n Joint1Model__Seed2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 1 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -end2end'
cl run -n Joint1Model__Seed3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 1 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -end2end'
cl run -n Joint1Model --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :Joint1Model__Seed1 :Joint1Model__Seed2 :Joint1Model__Seed3 'python3 src/CUB/inference.py -model_dirs Joint1Model__Seed1/outputs/best_model_1.pth Joint1Model__Seed2/outputs/best_model_2.pth Joint1Model__Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10'

### Multitask Model
cl run -n MultitaskModel_Seed1 --request-memory 4g --request-gpus 1 :src,places365: :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Multitask --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 20'
cl run -n MultitaskModel_Seed2 --request-memory 4g --request-gpus 1 :src,places365: :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Multitask --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 20'
cl run -n MultitaskModel_Seed3 --request-memory 4g --request-gpus 1 :src,places365: :CUB_200_2011 :CUB_processed :pretrained 'python3 src/experiments.py cub Multitask --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 20'
cl run -n MultitaskModel --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :MultitaskModel_Seed1 :MultitaskModel_Seed2 :MultitaskModel_Seed3 'python3 src/CUB/inference.py -model_dirs MultitaskModel_Seed1/outputs/best_model_1.pth MultitaskModel_Seed2/outputs/best_model_2.pth MultitaskModel_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10'

## ======================= Test-time intervention experiments =======================
### Independent Model
cl run -n TTI__IndependentModel_WithValSigmoid --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB :CUB_processed :ConceptModel__Seed1 :ConceptModel__Seed2 :ConceptModel__Seed3 :IndependentModel_WithVal___Seed1 :IndependentModel_WithVal___Seed2 :IndependentModel_WithVal___Seed3 'python3 src/CUB/tti.py -model_dirs ConceptModel__Seed1/outputs/best_model_1.pth ConceptModel__Seed2/outputs/best_model_2.pth ConceptModel__Seed3/outputs/best_model_3.pth -model_dirs2 IndependentModel_WithVal___Seed1/outputs/best_model_1.pth IndependentModel_WithVal___Seed2/outputs/best_model_2.pth IndependentModel_WithVal___Seed3/outputs/best_model_3.pth -use_attr -bottleneck -mode random -n_trials 5 -use_invisible -class_level -data_dir2 CUB -data_dir CUB_processed/class_attr_data_10 -use_sigmoid'

### Sequential Model
cl run -n TTI__SequentialModel_WithVal --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB :CUB_processed :ConceptModel__Seed1 :ConceptModel__Seed2 :ConceptModel__Seed3 :SequentialModel_WithVal__Seed1 :SequentialModel_WithVal__Seed2 :SequentialModel_WithVal__Seed3 'python3 src/CUB/tti.py -model_dirs ConceptModel__Seed1/outputs/best_model_1.pth ConceptModel__Seed2/outputs/best_model_2.pth ConceptModel__Seed3/outputs/best_model_3.pth -model_dirs2 SequentialModel_WithVal__Seed1/outputs/best_model_1.pth SequentialModel_WithVal__Seed2/outputs/best_model_2.pth SequentialModel_WithVal__Seed3/outputs/best_model_3.pth -use_attr -bottleneck -mode random -n_trials 5 -use_invisible -class_level -data_dir2 CUB -data_dir CUB_processed/class_attr_data_10'

### Joint Model
cl run -n TTI__Joint0.01SigmoidModel --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB :CUB_processed :Joint0.01SigmoidModel__Seed1 :Joint0.01SigmoidModel__Seed2 :Joint0.01SigmoidModel__Seed3 'python3 src/CUB/tti.py -model_dirs Joint0.01SigmoidModel__Seed1/outputs/best_model_1.pth Joint0.01SigmoidModel__Seed2/outputs/best_model_2.pth Joint0.01SigmoidModel__Seed3/outputs/best_model_3.pth -use_sigmoid -use_attr -mode random -n_trials 5 -use_invisible -class_level -data_dir2 CUB -data_dir CUB_processed/class_attr_data_10'
cl run -n TTI__Joint0.01Model --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB :CUB_processed :Joint0.01Model__Seed1 :Joint0.01Model__Seed2 'python3 src/CUB/tti.py -model_dirs Joint0.01Model__Seed1/outputs/best_model_1.pth Joint0.01Model__Seed2/outputs/best_model_2.pth -use_attr -mode random -n_trials 5 -use_invisible -class_level -data_dir2 CUB -data_dir CUB_processed/class_attr_data_10'

## ======================= Robustness experiments =======================
### Generate Adversarial Data
cl run -n AdversarialData --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 'python3 src/CUB/gen_cub_synthetic.py --cub_dir CUB_200_2011 --places_dir places365'

### Concept Model
cl run -n ConceptAdversarialModel1_ChangeDir_Train --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :pretrained 'python3 src/CUB/generate_new_data.py ChangeAdversarialDataDir --adv_data_dir AdversarialData/CUB_fixed --train_splits train val --data_dir CUB_processed/class_attr_data_10 --out_dir masked_datasets/'
cl run -n ConceptAdversarialModel2_ChangeDir_Train --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :pretrained 'python3 src/CUB/generate_new_data.py ChangeAdversarialDataDir --adv_data_dir AdversarialData/CUB_fixed --train_splits train val --data_dir CUB_processed/class_attr_data_10 --out_dir masked_datasets/'
cl run -n ConceptAdversarialModel3_ChangeDir_Train --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :pretrained 'python3 src/CUB/generate_new_data.py ChangeAdversarialDataDir --adv_data_dir AdversarialData/CUB_fixed --train_splits train val --data_dir CUB_processed/class_attr_data_10 --out_dir masked_datasets/'
cl run -n ConceptAdversarialModel__Seed1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :pretrained 'python3 src/experiments.py cub Concept_XtoC --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck -image_dir AdversarialData/CUB_fixed/train'
cl run -n ConceptAdversarialModel__Seed2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :pretrained 'python3 src/experiments.py cub Concept_XtoC --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck -image_dir AdversarialData/CUB_fixed/train'
cl run -n ConceptAdversarialModel__Seed3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :pretrained 'python3 src/experiments.py cub Concept_XtoC --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck -image_dir AdversarialData/CUB_fixed/train'
cl run -n ConceptAdversarialModel1__PredConcepts --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :ConceptAdversarialModel1_ChangeDir_Train :pretrained :ConceptAdversarialModel__Seed1 'python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptAdversarialModel__Seed1/outputs/best_model_1.pth --data_dir ConceptAdversarialModel1_ChangeDir_Train/masked_datasets --out_dir .'
cl run -n ConceptAdversarialModel2__PredConcepts --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :ConceptAdversarialModel2_ChangeDir_Train :pretrained :ConceptAdversarialModel__Seed2 'python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptAdversarialModel__Seed2/outputs/best_model_2.pth --data_dir ConceptAdversarialModel2_ChangeDir_Train/masked_datasets --out_dir .'
cl run -n ConceptAdversarialModel3__PredConcepts --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :ConceptAdversarialModel3_ChangeDir_Train :pretrained :ConceptAdversarialModel__Seed3 'python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptAdversarialModel__Seed3/outputs/best_model_3.pth --data_dir ConceptAdversarialModel3_ChangeDir_Train/masked_datasets --out_dir .'

### Independent Model
cl run -n IndependentAdversarialSigmoidModel__Seed1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :pretrained 'python3 src/experiments.py cub Independent_CtoY --seed 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000 -image_dir AdversarialData/CUB_fixed/train -use_sigmoid'
cl run -n IndependentAdversarialSigmoidModel__Seed2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :pretrained 'python3 src/experiments.py cub Independent_CtoY --seed 2 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000 -image_dir AdversarialData/CUB_fixed/train -use_sigmoid'
cl run -n IndependentAdversarialSigmoidModel__Seed3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :pretrained 'python3 src/experiments.py cub Independent_CtoY --seed 3 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000 -image_dir AdversarialData/CUB_fixed/train -use_sigmoid'
cl run -n IndependentAdversarialSigmoidModel --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :ConceptAdversarialModel__Seed1 :ConceptAdversarialModel__Seed2 :ConceptAdversarialModel__Seed3 :IndependentAdversarialSigmoidModel__Seed1 :IndependentAdversarialSigmoidModel__Seed2 :IndependentAdversarialSigmoidModel__Seed3 'python3 src/CUB/inference.py -model_dirs ConceptAdversarialModel__Seed1/outputs/best_model_1.pth ConceptAdversarialModel__Seed2/outputs/best_model_2.pth ConceptAdversarialModel__Seed3/outputs/best_model_3.pth -model_dirs2 IndependentAdversarialSigmoidModel__Seed1/outputs/best_model_1.pth IndependentAdversarialSigmoidModel__Seed2/outputs/best_model_2.pth IndependentAdversarialSigmoidModel__Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck -image_dir AdversarialData/CUB_fixed/test/ -use_sigmoid'

### Sequential Model
cl run -n SequentialAdversarialModel__Seed1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :pretrained :ConceptAdversarialModel1__PredConcepts 'python3 src/experiments.py cub Sequential_CtoY --seed 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptAdversarialModel1__PredConcepts -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000 -image_dir AdversarialData/CUB_fixed/train'
cl run -n SequentialAdversarialModel__Seed2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :pretrained :ConceptAdversarialModel2__PredConcepts 'python3 src/experiments.py cub Sequential_CtoY --seed 2 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptAdversarialModel2__PredConcepts -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000 -image_dir AdversarialData/CUB_fixed/train'
cl run -n SequentialAdversarialModel__Seed3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :pretrained :ConceptAdversarialModel3__PredConcepts 'python3 src/experiments.py cub Sequential_CtoY --seed 3 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptAdversarialModel3__PredConcepts -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000 -image_dir AdversarialData/CUB_fixed/train'
cl run -n SequentialAdversarialModel --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :ConceptAdversarialModel__Seed1 :ConceptAdversarialModel__Seed2 :ConceptAdversarialModel__Seed3 :SequentialAdversarialModel__Seed1 :SequentialAdversarialModel__Seed2 :SequentialAdversarialModel__Seed3 'python3 src/CUB/inference.py -model_dirs ConceptAdversarialModel__Seed1/outputs/best_model_1.pth ConceptAdversarialModel__Seed2/outputs/best_model_2.pth ConceptAdversarialModel__Seed3/outputs/best_model_3.pth -model_dirs2 SequentialAdversarialModel__Seed1/outputs/best_model_1.pth SequentialAdversarialModel__Seed2/outputs/best_model_2.pth SequentialAdversarialModel__Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck -image_dir AdversarialData/CUB_fixed/test/'

### Standard Model
cl run -n Joint0AdversarialModel__Seed1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :pretrained 'python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end -image_dir AdversarialData/CUB_fixed/train'
cl run -n Joint0AdversarialModel__Seed2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :pretrained 'python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end -image_dir AdversarialData/CUB_fixed/train'
cl run -n Joint0AdversarialModel__Seed3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :pretrained 'python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end -image_dir AdversarialData/CUB_fixed/train'
cl run -n Joint0AdversarialModel --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :Joint0AdversarialModel__Seed1 :Joint0AdversarialModel__Seed2 :Joint0AdversarialModel__Seed3 'python3 src/CUB/inference.py -model_dirs Joint0AdversarialModel__Seed1/outputs/best_model_1.pth Joint0AdversarialModel__Seed2/outputs/best_model_2.pth Joint0AdversarialModel__Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -image_dir AdversarialData/CUB_fixed/test/'

### Joint Model
cl run -n Joint0.01AdversarialModel__Seed1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :pretrained 'python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end -image_dir AdversarialData/CUB_fixed/train'
cl run -n Joint0.01AdversarialModel__Seed2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :pretrained 'python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end -image_dir AdversarialData/CUB_fixed/train'
cl run -n Joint0.01AdversarialModel__Seed3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :pretrained 'python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir CUB_processed/class_attr_data_10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end -image_dir AdversarialData/CUB_fixed/train'
cl run -n Joint0.01AdversarialModel --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :AdversarialData :Joint0.01AdversarialModel__Seed1 :Joint0.01AdversarialModel__Seed2 :Joint0.01AdversarialModel__Seed3 'python3 src/CUB/inference.py -model_dirs Joint0.01AdversarialModel__Seed1/outputs/best_model_1.pth Joint0.01AdversarialModel__Seed2/outputs/best_model_2.pth Joint0.01AdversarialModel__Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -image_dir AdversarialData/CUB_fixed/test/'

## ======================= Data efficiency experiments =======================
### Generate Data Splits
cl run -n DataEfficiencySplits_N1 --request-memory 4g --request-gpus 1 :src :CUB_processed 'python3 src/CUB/generate_new_data.py DataEfficiencySplits --n_samples 1 --out_dir . --splits_dir CUB_processed/class_attr_data_10'
cl run -n DataEfficiencySplits_N3 --request-memory 4g --request-gpus 1 :src :CUB_processed 'python3 src/CUB/generate_new_data.py DataEfficiencySplits --n_samples 3 --out_dir . --splits_dir CUB_processed/class_attr_data_10'
cl run -n DataEfficiencySplits_N7 --request-memory 4g --request-gpus 1 :src :CUB_processed 'python3 src/CUB/generate_new_data.py DataEfficiencySplits --n_samples 7 --out_dir . --splits_dir CUB_processed/class_attr_data_10'
cl run -n DataEfficiencySplits_N10 --request-memory 4g --request-gpus 1 :src :CUB_processed 'python3 src/CUB/generate_new_data.py DataEfficiencySplits --n_samples 10 --out_dir . --splits_dir CUB_processed/class_attr_data_10'
cl run -n DataEfficiencySplits_N15 --request-memory 4g --request-gpus 1 :src :CUB_processed 'python3 src/CUB/generate_new_data.py DataEfficiencySplits --n_samples 15 --out_dir . --splits_dir CUB_processed/class_attr_data_10'

### Concept Model
cl run -n ConceptModel_DataEffN1_Seed1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N1 :pretrained 'python3 src/experiments.py cub Concept_XtoC --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N1 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck'
cl run -n ConceptModel_DataEffN1_Seed2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N1 :pretrained 'python3 src/experiments.py cub Concept_XtoC --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N1 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck'
cl run -n ConceptModel_DataEffN1_Seed3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N1 :pretrained 'python3 src/experiments.py cub Concept_XtoC --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N1 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck'
cl run -n ConceptModelDataEffN1_PredConcepts1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N1 :pretrained :ConceptModel_DataEffN1_Seed1 'python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN1_Seed1/outputs/best_model_1.pth --data_dir DataEfficiencySplits_N1 --out_dir .'
cl run -n ConceptModelDataEffN1_PredConcepts2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N1 :pretrained :ConceptModel_DataEffN1_Seed2 'python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN1_Seed2/outputs/best_model_2.pth --data_dir DataEfficiencySplits_N1 --out_dir .'
cl run -n ConceptModelDataEffN1_PredConcepts3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N1 :pretrained :ConceptModel_DataEffN1_Seed3 'python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN1_Seed3/outputs/best_model_3.pth --data_dir DataEfficiencySplits_N1 --out_dir .'
cl run -n ConceptModel_DataEffN3_Seed1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N3 :pretrained 'python3 src/experiments.py cub Concept_XtoC --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N3 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck'
cl run -n ConceptModel_DataEffN3_Seed2 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N3 :pretrained 'python3 src/experiments.py cub Concept_XtoC --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N3 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck'
cl run -n ConceptModel_DataEffN3_Seed3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N3 :pretrained 'python3 src/experiments.py cub Concept_XtoC --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N3 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck'
cl run -n ConceptModelDataEffN3_PredConcepts1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N3 :pretrained :ConceptModel_DataEffN3_Seed1 'python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN3_Seed1/outputs/best_model_1.pth --data_dir DataEfficiencySplits_N3 --out_dir .'
cl run -n ConceptModelDataEffN3_PredConcepts2 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N3 :pretrained :ConceptModel_DataEffN3_Seed2 'python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN3_Seed2/outputs/best_model_2.pth --data_dir DataEfficiencySplits_N3 --out_dir .'
cl run -n ConceptModelDataEffN3_PredConcepts3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N3 :pretrained :ConceptModel_DataEffN3_Seed3 'python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN3_Seed3/outputs/best_model_3.pth --data_dir DataEfficiencySplits_N3 --out_dir .'
cl run -n ConceptModel_DataEffN7_Seed1 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N7 :pretrained 'python3 src/experiments.py cub Concept_XtoC --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N7 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck'
cl run -n ConceptModel_DataEffN7_Seed2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N7 :pretrained 'python3 src/experiments.py cub Concept_XtoC --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N7 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck'
cl run -n ConceptModel_DataEffN7_Seed3 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N7 :pretrained 'python3 src/experiments.py cub Concept_XtoC --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N7 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck'
cl run -n ConceptModelDataEffN7_PredConcepts1 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N7 :pretrained :ConceptModel_DataEffN7_Seed1 'python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN7_Seed1/outputs/best_model_1.pth --data_dir DataEfficiencySplits_N7 --out_dir .'
cl run -n ConceptModelDataEffN7_PredConcepts2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N7 :pretrained :ConceptModel_DataEffN7_Seed2 'python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN7_Seed2/outputs/best_model_2.pth --data_dir DataEfficiencySplits_N7 --out_dir .'
cl run -n ConceptModelDataEffN7_PredConcepts3 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N7 :pretrained :ConceptModel_DataEffN7_Seed3 'python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN7_Seed3/outputs/best_model_3.pth --data_dir DataEfficiencySplits_N7 --out_dir .'
cl run -n ConceptModel_DataEffN10_Seed1 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N10 :pretrained 'python3 src/experiments.py cub Concept_XtoC --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N10 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck'
cl run -n ConceptModel_DataEffN10_Seed2 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N10 :pretrained 'python3 src/experiments.py cub Concept_XtoC --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N10 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck'
cl run -n ConceptModel_DataEffN10_Seed3 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N10 :pretrained 'python3 src/experiments.py cub Concept_XtoC --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N10 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck'
cl run -n ConceptModelDataEffN10_PredConcepts1 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N10 :pretrained :ConceptModel_DataEffN10_Seed1 'python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN10_Seed1/outputs/best_model_1.pth --data_dir DataEfficiencySplits_N10 --out_dir .'
cl run -n ConceptModelDataEffN10_PredConcepts2 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N10 :pretrained :ConceptModel_DataEffN10_Seed2 'python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN10_Seed2/outputs/best_model_2.pth --data_dir DataEfficiencySplits_N10 --out_dir .'
cl run -n ConceptModelDataEffN10_PredConcepts3 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N10 :pretrained :ConceptModel_DataEffN10_Seed3 'python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN10_Seed3/outputs/best_model_3.pth --data_dir DataEfficiencySplits_N10 --out_dir .'
cl run -n ConceptModel_DataEffN15_Seed1 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N15 :pretrained 'python3 src/experiments.py cub Concept_XtoC --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N15 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck'
cl run -n ConceptModel_DataEffN15_Seed2 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N15 :pretrained 'python3 src/experiments.py cub Concept_XtoC --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N15 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck'
cl run -n ConceptModel_DataEffN15_Seed3 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N15 :pretrained 'python3 src/experiments.py cub Concept_XtoC --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N15 -n_attributes 112 -normalize_loss -b 64 -weight_decay 0.00004 -lr 0.01 -scheduler_step 1000 -bottleneck'
cl run -n ConceptModelDataEffN15_PredConcepts1 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N15 :pretrained :ConceptModel_DataEffN15_Seed1 'python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN15_Seed1/outputs/best_model_1.pth --data_dir DataEfficiencySplits_N15 --out_dir .'
cl run -n ConceptModelDataEffN15_PredConcepts2 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N15 :pretrained :ConceptModel_DataEffN15_Seed2 'python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN15_Seed2/outputs/best_model_2.pth --data_dir DataEfficiencySplits_N15 --out_dir .'
cl run -n ConceptModelDataEffN15_PredConcepts3 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N15 :pretrained :ConceptModel_DataEffN15_Seed3 'python3 src/CUB/generate_new_data.py ExtractConcepts --model_path ConceptModel_DataEffN15_Seed3/outputs/best_model_3.pth --data_dir DataEfficiencySplits_N15 --out_dir .'

### Independent Model
cl run -n IndependentModel_WithVal_DataEffN1_Seed1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N1 :pretrained 'python3 src/experiments.py cub Independent_CtoY --seed 1 -log_dir outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N1 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000'
cl run -n IndependentModel_WithVal_DataEffN1_Seed2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N1 :pretrained 'python3 src/experiments.py cub Independent_CtoY --seed 2 -log_dir outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N1 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000'
cl run -n IndependentModel_WithVal_DataEffN1_Seed3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N1 :pretrained 'python3 src/experiments.py cub Independent_CtoY --seed 3 -log_dir outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N1 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000'
cl run -n IndependentModel_WithVal_DataEffN3_Seed1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N3 :pretrained 'python3 src/experiments.py cub Independent_CtoY --seed 1 -log_dir outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N3 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000'
cl run -n IndependentModel_WithVal_DataEffN3_Seed2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N3 :pretrained 'python3 src/experiments.py cub Independent_CtoY --seed 2 -log_dir outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N3 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000'
cl run -n IndependentModel_WithVal_DataEffN3_Seed3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N3 :pretrained 'python3 src/experiments.py cub Independent_CtoY --seed 3 -log_dir outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N3 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000'
cl run -n IndependentModel_WithVal_DataEffN3_Seed2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N3 :pretrained 'python3 src/experiments.py cub Independent_CtoY --seed 2 -log_dir outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N3 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000'
cl run -n IndependentModel_WithVal_DataEffN3_Seed3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N3 :pretrained 'python3 src/experiments.py cub Independent_CtoY --seed 3 -log_dir outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N3 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000'
cl run -n IndependentModel_WithVal_DataEffN10_Seed1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N10 :pretrained 'python3 src/experiments.py cub Independent_CtoY --seed 1 -log_dir outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N10 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000'
cl run -n IndependentModel_WithVal_DataEffN10_Seed2 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N10 :pretrained 'python3 src/experiments.py cub Independent_CtoY --seed 2 -log_dir outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N10 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000'
cl run -n IndependentModel_WithVal_DataEffN10_Seed3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N10 :pretrained 'python3 src/experiments.py cub Independent_CtoY --seed 3 -log_dir outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N10 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000'
cl run -n IndependentModel_WithVal_DataEffN15_Seed1 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N15 :pretrained 'python3 src/experiments.py cub Independent_CtoY --seed 1 -log_dir outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N15 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000'
cl run -n IndependentModel_WithVal_DataEffN15_Seed2 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N15 :pretrained 'python3 src/experiments.py cub Independent_CtoY --seed 2 -log_dir outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N15 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000'
cl run -n IndependentModel_WithVal_DataEffN15_Seed3 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N15 :pretrained 'python3 src/experiments.py cub Independent_CtoY --seed 3 -log_dir outputs/ -e 1000 -optimizer sgd -use_attr -data_dir DataEfficiencySplits_N15 -n_attributes 112 -no_img -b 64 -weight_decay 0.00005 -lr 0.001 -scheduler_step 1000'

cl run -n IndependentModel_WithVal_DataEffN1_Result --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :ConceptModel_DataEffN1_Seed1 :ConceptModel_DataEffN1_Seed2 :ConceptModel_DataEffN1_Seed3 :IndependentModel_WithVal_DataEffN1_Seed1 :IndependentModel_WithVal_DataEffN1_Seed2 :IndependentModel_WithVal_DataEffN1_Seed3 'python3 src/CUB/inference.py -model_dirs ConceptModel_DataEffN1_Seed1/outputs/best_model_1.pth ConceptModel_DataEffN1_Seed2/outputs/best_model_2.pth ConceptModel_DataEffN1_Seed3/outputs/best_model_3.pth -model_dirs2 IndependentModel_WithVal_DataEffN1_Seed1/outputs/best_model_1.pth IndependentModel_WithVal_DataEffN1_Seed2/outputs/best_model_2.pth IndependentModel_WithVal_DataEffN1_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck -use_sigmoid'
cl run -n IndependentModel_WithVal_DataEffN3_Result --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :ConceptModel_DataEffN3_Seed1 :ConceptModel_DataEffN3_Seed2 :ConceptModel_DataEffN3_Seed3 :IndependentModel_WithVal_DataEffN3_Seed1 :IndependentModel_WithVal_DataEffN3_Seed2 :IndependentModel_WithVal_DataEffN3_Seed3 'python3 src/CUB/inference.py -model_dirs ConceptModel_DataEffN3_Seed1/outputs/best_model_1.pth ConceptModel_DataEffN3_Seed2/outputs/best_model_2.pth ConceptModel_DataEffN3_Seed3/outputs/best_model_3.pth -model_dirs2 IndependentModel_WithVal_DataEffN3_Seed1/outputs/best_model_1.pth IndependentModel_WithVal_DataEffN3_Seed2/outputs/best_model_2.pth IndependentModel_WithVal_DataEffN3_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck -use_sigmoid'
cl run -n IndependentModel_WithVal_DataEffN7_Result --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :ConceptModel_DataEffN7_Seed1 :ConceptModel_DataEffN7_Seed2 :ConceptModel_DataEffN7_Seed3 :IndependentModel_WithVal_DataEffN7_Seed1 :IndependentModel_WithVal_DataEffN7_Seed2 :IndependentModel_WithVal_DataEffN7_Seed3 'python3 src/CUB/inference.py -model_dirs ConceptModel_DataEffN7_Seed1/outputs/best_model_1.pth ConceptModel_DataEffN7_Seed2/outputs/best_model_2.pth ConceptModel_DataEffN7_Seed3/outputs/best_model_3.pth -model_dirs2 IndependentModel_WithVal_DataEffN7_Seed1/outputs/best_model_1.pth IndependentModel_WithVal_DataEffN7_Seed2/outputs/best_model_2.pth IndependentModel_WithVal_DataEffN7_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck -use_sigmoid'
cl run -n IndependentModel_WithVal_DataEffN10_Result --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :ConceptModel_DataEffN10_Seed1 :ConceptModel_DataEffN10_Seed2 :ConceptModel_DataEffN10_Seed3 :IndependentModel_WithVal_DataEffN10_Seed1 :IndependentModel_WithVal_DataEffN10_Seed2 :IndependentModel_WithVal_DataEffN10_Seed3 'python3 src/CUB/inference.py -model_dirs ConceptModel_DataEffN10_Seed1/outputs/best_model_1.pth ConceptModel_DataEffN10_Seed2/outputs/best_model_2.pth ConceptModel_DataEffN10_Seed3/outputs/best_model_3.pth -model_dirs2 IndependentModel_WithVal_DataEffN10_Seed1/outputs/best_model_1.pth IndependentModel_WithVal_DataEffN10_Seed2/outputs/best_model_2.pth IndependentModel_WithVal_DataEffN10_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck -use_sigmoid'
cl run -n IndependentModel_WithVal_DataEffN15_Result --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :ConceptModel_DataEffN15_Seed1 :ConceptModel_DataEffN15_Seed2 :ConceptModel_DataEffN15_Seed3 :IndependentModel_WithVal_DataEffN15_Seed1 :IndependentModel_WithVal_DataEffN15_Seed2 :IndependentModel_WithVal_DataEffN15_Seed3 'python3 src/CUB/inference.py -model_dirs ConceptModel_DataEffN15_Seed1/outputs/best_model_1.pth ConceptModel_DataEffN15_Seed2/outputs/best_model_2.pth ConceptModel_DataEffN15_Seed3/outputs/best_model_3.pth -model_dirs2 IndependentModel_WithVal_DataEffN15_Seed1/outputs/best_model_1.pth IndependentModel_WithVal_DataEffN15_Seed2/outputs/best_model_2.pth IndependentModel_WithVal_DataEffN15_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck -use_sigmoid'

### Sequential Model
cl run -n SequentialModel_WithVal_DataEffN1_Seed1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained :ConceptModelDataEffN1_PredConcepts1 'python3 src/experiments.py cub Sequential_CtoY --seed 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN1_PredConcepts1 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000'
cl run -n SequentialModel_WithVal_DataEffN1_Seed2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained :ConceptModelDataEffN1_PredConcepts2 'python3 src/experiments.py cub Sequential_CtoY --seed 2 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN1_PredConcepts2 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000'
cl run -n SequentialModel_WithVal_DataEffN1_Seed3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained :ConceptModelDataEffN1_PredConcepts3 'python3 src/experiments.py cub Sequential_CtoY --seed 3 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN1_PredConcepts3 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000'
cl run -n SequentialModel_WithVal_DataEffN3_Seed1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained :ConceptModelDataEffN3_PredConcepts1 'python3 src/experiments.py cub Sequential_CtoY --seed 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN3_PredConcepts1 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000'
cl run -n SequentialModel_WithVal_DataEffN3_Seed2 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :CUB_processed :pretrained :ConceptModelDataEffN3_PredConcepts2 'python3 src/experiments.py cub Sequential_CtoY --seed 2 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN3_PredConcepts2 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000'
cl run -n SequentialModel_WithVal_DataEffN3_Seed3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained :ConceptModelDataEffN3_PredConcepts3 'python3 src/experiments.py cub Sequential_CtoY --seed 3 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN3_PredConcepts3 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000'
cl run -n SequentialModel_WithVal_DataEffN7_Seed1 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :CUB_processed :pretrained :ConceptModelDataEffN7_PredConcepts1 'python3 src/experiments.py cub Sequential_CtoY --seed 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN7_PredConcepts1 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000'
cl run -n SequentialModel_WithVal_DataEffN7_Seed2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :pretrained :ConceptModelDataEffN7_PredConcepts2 'python3 src/experiments.py cub Sequential_CtoY --seed 2 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN7_PredConcepts2 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000'
cl run -n SequentialModel_WithVal_DataEffN7_Seed3 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :CUB_processed :pretrained :ConceptModelDataEffN7_PredConcepts3 'python3 src/experiments.py cub Sequential_CtoY --seed 3 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN7_PredConcepts3 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000'
cl run -n SequentialModel_WithVal_DataEffN10_Seed1 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :CUB_processed :pretrained :ConceptModelDataEffN10_PredConcepts1 'python3 src/experiments.py cub Sequential_CtoY --seed 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN10_PredConcepts1 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000'
cl run -n SequentialModel_WithVal_DataEffN10_Seed2 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :CUB_processed :pretrained :ConceptModelDataEffN10_PredConcepts2 'python3 src/experiments.py cub Sequential_CtoY --seed 2 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN10_PredConcepts2 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000'
cl run -n SequentialModel_WithVal_DataEffN10_Seed3 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :CUB_processed :pretrained :ConceptModelDataEffN10_PredConcepts3 'python3 src/experiments.py cub Sequential_CtoY --seed 3 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN10_PredConcepts3 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000'
cl run -n SequentialModel_WithVal_DataEffN10_Seed1 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :CUB_processed :pretrained :ConceptModelDataEffN10_PredConcepts1 'python3 src/experiments.py cub Sequential_CtoY --seed 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN10_PredConcepts1 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000'
cl run -n SequentialModel_WithVal_DataEffN10_Seed2 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :CUB_processed :pretrained :ConceptModelDataEffN10_PredConcepts2 'python3 src/experiments.py cub Sequential_CtoY --seed 2 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN10_PredConcepts2 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000'
cl run -n SequentialModel_WithVal_DataEffN10_Seed3 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :CUB_processed :pretrained :ConceptModelDataEffN10_PredConcepts3 'python3 src/experiments.py cub Sequential_CtoY --seed 3 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN10_PredConcepts3 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000'
cl run -n SequentialModel_WithVal_DataEffN15_Seed1 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :CUB_processed :pretrained :ConceptModelDataEffN15_PredConcepts1 'python3 src/experiments.py cub Sequential_CtoY --seed 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN15_PredConcepts1 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000'
cl run -n SequentialModel_WithVal_DataEffN15_Seed2 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :CUB_processed :pretrained :ConceptModelDataEffN15_PredConcepts2 'python3 src/experiments.py cub Sequential_CtoY --seed 2 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN15_PredConcepts2 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000'
cl run -n SequentialModel_WithVal_DataEffN15_Seed3 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :CUB_processed :pretrained :ConceptModelDataEffN15_PredConcepts3 'python3 src/experiments.py cub Sequential_CtoY --seed 3 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -data_dir ConceptModelDataEffN15_PredConcepts3 -n_attributes 112 -no_img -b 64 -weight_decay 0.00004 -lr 0.001 -scheduler_step 1000'

cl run -n SequentialModel_WithVal_DataEffN1_Result --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :ConceptModel_DataEffN1_Seed1 :ConceptModel_DataEffN1_Seed2 :ConceptModel_DataEffN1_Seed3 :SequentialModel_WithVal_DataEffN1_Seed1 :SequentialModel_WithVal_DataEffN1_Seed2 :SequentialModel_WithVal_DataEffN1_Seed3 'python3 src/CUB/inference.py -model_dirs ConceptModel_DataEffN1_Seed1/outputs/best_model_1.pth ConceptModel_DataEffN1_Seed2/outputs/best_model_2.pth ConceptModel_DataEffN1_Seed3/outputs/best_model_3.pth -model_dirs2 SequentialModel_WithVal_DataEffN1_Seed1/outputs/best_model_1.pth SequentialModel_WithVal_DataEffN1_Seed2/outputs/best_model_2.pth SequentialModel_WithVal_DataEffN1_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck'
cl run -n SequentialModel_WithVal_DataEffN3_Result --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :ConceptModel_DataEffN3_Seed1 :ConceptModel_DataEffN3_Seed2 :ConceptModel_DataEffN3_Seed3 :SequentialModel_WithVal_DataEffN3_Seed1 :SequentialModel_WithVal_DataEffN3_Seed2 :SequentialModel_WithVal_DataEffN3_Seed3 'python3 src/CUB/inference.py -model_dirs ConceptModel_DataEffN3_Seed1/outputs/best_model_1.pth ConceptModel_DataEffN3_Seed2/outputs/best_model_2.pth ConceptModel_DataEffN3_Seed3/outputs/best_model_3.pth -model_dirs2 SequentialModel_WithVal_DataEffN3_Seed1/outputs/best_model_1.pth SequentialModel_WithVal_DataEffN3_Seed2/outputs/best_model_2.pth SequentialModel_WithVal_DataEffN3_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck'
cl run -n SequentialModel_WithVal_DataEffN7_Result --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :ConceptModel_DataEffN7_Seed1 :ConceptModel_DataEffN7_Seed2 :ConceptModel_DataEffN7_Seed3 :SequentialModel_WithVal_DataEffN7_Seed1 :SequentialModel_WithVal_DataEffN7_Seed2 :SequentialModel_WithVal_DataEffN7_Seed3 'python3 src/CUB/inference.py -model_dirs ConceptModel_DataEffN7_Seed1/outputs/best_model_1.pth ConceptModel_DataEffN7_Seed2/outputs/best_model_2.pth ConceptModel_DataEffN7_Seed3/outputs/best_model_3.pth -model_dirs2 SequentialModel_WithVal_DataEffN7_Seed1/outputs/best_model_1.pth SequentialModel_WithVal_DataEffN7_Seed2/outputs/best_model_2.pth SequentialModel_WithVal_DataEffN7_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck'
cl run -n SequentialModel_WithVal_DataEffN10_Result --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :ConceptModel_DataEffN10_Seed1 :ConceptModel_DataEffN10_Seed2 :ConceptModel_DataEffN10_Seed3 :SequentialModel_WithVal_DataEffN10_Seed1 :SequentialModel_WithVal_DataEffN10_Seed2 :SequentialModel_WithVal_DataEffN10_Seed3 'python3 src/CUB/inference.py -model_dirs ConceptModel_DataEffN10_Seed1/outputs/best_model_1.pth ConceptModel_DataEffN10_Seed2/outputs/best_model_2.pth ConceptModel_DataEffN10_Seed3/outputs/best_model_3.pth -model_dirs2 SequentialModel_WithVal_DataEffN10_Seed1/outputs/best_model_1.pth SequentialModel_WithVal_DataEffN10_Seed2/outputs/best_model_2.pth SequentialModel_WithVal_DataEffN10_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck'
cl run -n SequentialModel_WithVal_DataEffN15_Result --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :ConceptModel_DataEffN15_Seed1 :ConceptModel_DataEffN15_Seed2 :ConceptModel_DataEffN15_Seed3 :SequentialModel_WithVal_DataEffN15_Seed1 :SequentialModel_WithVal_DataEffN15_Seed2 :SequentialModel_WithVal_DataEffN15_Seed3 'python3 src/CUB/inference.py -model_dirs ConceptModel_DataEffN15_Seed1/outputs/best_model_1.pth ConceptModel_DataEffN15_Seed2/outputs/best_model_2.pth ConceptModel_DataEffN15_Seed3/outputs/best_model_3.pth -model_dirs2 SequentialModel_WithVal_DataEffN15_Seed1/outputs/best_model_1.pth SequentialModel_WithVal_DataEffN15_Seed2/outputs/best_model_2.pth SequentialModel_WithVal_DataEffN15_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10 -bottleneck'

### Standard Model
cl run -n Joint0Model_DataEffN1_Seed1 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N1 :pretrained 'python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N1 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0Model_DataEffN1_Seed2 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N1 :pretrained 'python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N1 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0Model_DataEffN1_Seed3 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N1 :pretrained 'python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N1 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0Model_DataEffN3_Seed1 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N3 :pretrained 'python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N3 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0Model_DataEffN3_Seed2 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N3 :pretrained 'python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N3 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0Model_DataEffN3_Seed3 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N3 :pretrained 'python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N3 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0Model_DataEffN7_Seed1 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N7 :pretrained 'python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N7 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0Model_DataEffN7_Seed2 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N7 :pretrained 'python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N7 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0Model_DataEffN7_Seed3 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N7 :pretrained 'python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N7 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0Model_DataEffN10_Seed1 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N10 :pretrained 'python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N10 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0Model_DataEffN10_Seed2 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N10 :pretrained 'python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N10 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0Model_DataEffN10_Seed3 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N10 :pretrained 'python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N10 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0Model_DataEffN15_Seed1 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N15 :pretrained 'python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N15 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0Model_DataEffN15_Seed2 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N15 :pretrained 'python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N15 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0Model_DataEffN15_Seed3 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N15 :pretrained 'python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N15 -n_attributes 112 -attr_loss_weight 0 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'

cl run -n Joint0Model_DataEffN1_Result --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :Joint0Model_DataEffN1_Seed1 :Joint0Model_DataEffN1_Seed2 :Joint0Model_DataEffN1_Seed3 'python3 src/CUB/inference.py -model_dirs Joint0Model_DataEffN1_Seed1/outputs/best_model_1.pth Joint0Model_DataEffN1_Seed2/outputs/best_model_2.pth Joint0Model_DataEffN1_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10'
cl run -n Joint0Model_DataEffN3_Result --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :Joint0Model_DataEffN3_Seed1 :Joint0Model_DataEffN3_Seed2 :Joint0Model_DataEffN3_Seed3 'python3 src/CUB/inference.py -model_dirs Joint0Model_DataEffN3_Seed1/outputs/best_model_1.pth Joint0Model_DataEffN3_Seed2/outputs/best_model_2.pth Joint0Model_DataEffN3_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10'
cl run -n Joint0Model_DataEffN7_Result --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :Joint0Model_DataEffN7_Seed1 :Joint0Model_DataEffN7_Seed2 :Joint0Model_DataEffN7_Seed3 'python3 src/CUB/inference.py -model_dirs Joint0Model_DataEffN7_Seed1/outputs/best_model_1.pth Joint0Model_DataEffN7_Seed2/outputs/best_model_2.pth Joint0Model_DataEffN7_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10'
cl run -n Joint0Model_DataEffN10_Result --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :Joint0Model_DataEffN10_Seed1 :Joint0Model_DataEffN10_Seed2 :Joint0Model_DataEffN10_Seed3 'python3 src/CUB/inference.py -model_dirs Joint0Model_DataEffN10_Seed1/outputs/best_model_1.pth Joint0Model_DataEffN10_Seed2/outputs/best_model_2.pth Joint0Model_DataEffN10_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10'
cl run -n Joint0Model_DataEffN15_Result --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :Joint0Model_DataEffN15_Seed1 :Joint0Model_DataEffN15_Seed2 :Joint0Model_DataEffN15_Seed3 'python3 src/CUB/inference.py -model_dirs Joint0Model_DataEffN15_Seed1/outputs/best_model_1.pth Joint0Model_DataEffN15_Seed2/outputs/best_model_2.pth Joint0Model_DataEffN15_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10'

### Joint Model
cl run -n Joint0.01Model_DataEffN1_Seed1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N1 :pretrained 'python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N1 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0.01Model_DataEffN1_Seed2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N1 :pretrained 'python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N1 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0.01Model_DataEffN1_Seed3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N1 :pretrained 'python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N1 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0.01Model_DataEffN3_Seed1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N3 :pretrained 'python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N3 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0.01Model_DataEffN3_Seed2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N3 :pretrained 'python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N3 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0.01Model_DataEffN3_Seed3 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N3 :pretrained 'python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N3 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0.01Model_DataEffN7_Seed1 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N7 :pretrained 'python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N7 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0.01Model_DataEffN7_Seed2 --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :DataEfficiencySplits_N7 :pretrained 'python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N7 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0.01Model_DataEffN7_Seed3 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N7 :pretrained 'python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N7 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0.01Model_DataEffN10_Seed1 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N10 :pretrained 'python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0.01Model_DataEffN10_Seed2 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N10 :pretrained 'python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0.01Model_DataEffN10_Seed3 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N10 :pretrained 'python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0.01Model_DataEffN10_Seed1 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N10 :pretrained 'python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0.01Model_DataEffN10_Seed2 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N10 :pretrained 'python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0.01Model_DataEffN10_Seed3 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N10 :pretrained 'python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N10 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0.01Model_DataEffN15_Seed1 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N15 :pretrained 'python3 src/experiments.py cub Joint --seed 1 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N15 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0.01Model_DataEffN15_Seed2 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N15 :pretrained 'python3 src/experiments.py cub Joint --seed 2 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N15 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'
cl run -n Joint0.01Model_DataEffN15_Seed3 --request-memory 4g --request-gpus 1 :src :CUB_200_2011 :DataEfficiencySplits_N15 :pretrained 'python3 src/experiments.py cub Joint --seed 3 -ckpt 1 -log_dir outputs/ -e 1000 -optimizer sgd -pretrained -use_aux -use_attr -weighted_loss multiple -data_dir DataEfficiencySplits_N15 -n_attributes 112 -attr_loss_weight 0.01 -normalize_loss -b 64 -weight_decay 0.0004 -lr 0.001 -scheduler_step 1000 -end2end'

cl run -n Joint0.01Model_DataEffN1_Result --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :Joint0.01Model_DataEffN1_Seed1 :Joint0.01Model_DataEffN1_Seed2 :Joint0.01Model_DataEffN1_Seed3 'python3 src/CUB/inference.py -model_dirs Joint0.01Model_DataEffN1_Seed1/outputs/best_model_1.pth Joint0.01Model_DataEffN1_Seed2/outputs/best_model_2.pth Joint0.01Model_DataEffN1_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10'
cl run -n Joint0.01Model_DataEffN3_Result --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :Joint0.01Model_DataEffN3_Seed1 :Joint0.01Model_DataEffN3_Seed2 :Joint0.01Model_DataEffN3_Seed3 'python3 src/CUB/inference.py -model_dirs Joint0.01Model_DataEffN3_Seed1/outputs/best_model_1.pth Joint0.01Model_DataEffN3_Seed2/outputs/best_model_2.pth Joint0.01Model_DataEffN3_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10'
cl run -n Joint0.01Model_DataEffN7_Result --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :Joint0.01Model_DataEffN7_Seed1 :Joint0.01Model_DataEffN7_Seed2 'python3 src/CUB/inference.py -model_dirs Joint0.01Model_DataEffN7_Seed1/outputs/best_model_1.pth Joint0.01Model_DataEffN7_Seed2/outputs/best_model_2.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10'
cl run -n Joint0.01Model_DataEffN10_Result --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :Joint0.01Model_DataEffN10_Seed1 :Joint0.01Model_DataEffN10_Seed2 :Joint0.01Model_DataEffN10_Seed3 'python3 src/CUB/inference.py -model_dirs Joint0.01Model_DataEffN10_Seed1/outputs/best_model_1.pth Joint0.01Model_DataEffN10_Seed2/outputs/best_model_2.pth Joint0.01Model_DataEffN10_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10'
cl run -n Joint0.01Model_DataEffN15_Result --request-memory 4g --request-gpus 1 :src :places365 :CUB_200_2011 :CUB_processed :Joint0.01Model_DataEffN15_Seed1 :Joint0.01Model_DataEffN15_Seed2 :Joint0.01Model_DataEffN15_Seed3 'python3 src/CUB/inference.py -model_dirs Joint0.01Model_DataEffN15_Seed1/outputs/best_model_1.pth Joint0.01Model_DataEffN15_Seed2/outputs/best_model_2.pth Joint0.01Model_DataEffN15_Seed3/outputs/best_model_3.pth -eval_data test -use_attr -n_attributes 112 -data_dir CUB_processed/class_attr_data_10'

# ======================= Figures =======================
cl run -n Results --request-memory 4g --request-gpus 1 :src :IndependentModel__WithValSigmoid :SequentialModel__WithVal :Joint0.001Model :Joint0.01Model :Joint0.1Model :Joint1Model :Joint0Model :Joint0Model_LinearProbe :StandardNoBNModel :MultitaskModel :Joint0Model_DataEffN1_Result :Joint0Model_DataEffN3_Result :Joint0Model_DataEffN7_Result :Joint0Model_DataEffN10_Result :Joint0Model_DataEffN15_Result :Joint0.01Model_DataEffN1_Result :Joint0.01Model_DataEffN3_Result :Joint0.01Model_DataEffN7_Result :Joint0.01Model_DataEffN10_Result :Joint0.01Model_DataEffN15_Result :IndependentModel_WithVal_DataEffN1_Result :IndependentModel_WithVal_DataEffN3_Result :IndependentModel_WithVal_DataEffN7_Result :IndependentModel_WithVal_DataEffN10_Result :IndependentModel_WithVal_DataEffN15_Result :SequentialModel_WithVal_DataEffN1_Result :SequentialModel_WithVal_DataEffN3_Result :SequentialModel_WithVal_DataEffN7_Result :SequentialModel_WithVal_DataEffN10_Result :SequentialModel_WithVal_DataEffN15_Result :TTI__Joint0.01Model :TTI__Joint0.01SigmoidModel :TTI__SequentialModel_WithVal :TTI__IndependentModel_WithValSigmoid :Joint0AdversarialModel :Joint0.01AdversarialModel :SequentialAdversarialModel :IndependentAdversarialSigmoidModel 'python3 src/CUB/plots.py'
