import numpy as np

if __name__ == '__main__':
    print("Warning: this script 'Player.py' is NOT executable..")  # DEBUG
    exit(0)

class Player(object):
    """ Base class for a player class."""

    def __init__(self, param):
        """ 
        Base class for a player class.
        For clarity, we require each child class to re-implement completely the __init__() method.
        """
        self.horizon = param["horizon"]  #: if the horizon is not known in advance, set it to None.
        self.nbArm = param["nbArm"]
        self.playerID = param["playerID"]
        
        self.arm_estimate = np.zeros(self.nbArm)
    
    # --- Printing
    def __str__(self):
        return self.__class__.__name__    
        
    # --- functionalities
    def explore(self, context = None, time = None):
        print("decision() should be implemented for agent adopting a particular algorithm.")
        
    
    def learn_arm_value(self, context = None, arm_values = None, collisions = None):
        print("learn_arm_value() should be implemented for agent adopting a particular algorithm.")
        
    def exploit(self, context = None, time=None):
        print("exploit() should be implemented for agent adopting a particular algorithm.")
        
    def reset(self):
        print("reset() should be implemented for agent adopting a particular algorithm.")
