# Leveraging Conditional Dependence for Efficient World Model Denoising

## Simple Introduction

The code includes the implementation of our proposed CsDreamer and provides the demonstration environment for DMC+CB. 
All environment code and execution commands will be released in the formal version.


### Running Instructions

After downloading the [DAVIS-2017-trainval-480p dataset](https://data.vision.ee.ethz.ch/csergi/share/davis/DAVIS-2017-trainval-480p.zip), the code can be run using the following command:

```shell
python dreamer.py \
        --configs dmc_vision_bg \
        --task dmcbg_walker_run \
        --logdir ./logdir/dmcbg_walker_run \
        --datapath path/to/DAVIS-2017-trainval-480p/DAVIS/JPEGImages/480p
```


### Key File Descriptions

- **`configs.yaml`**:  Contains the configuration parameters for CsDreamer.
- **`envs/`**: Implements the environments with noisy observations.
- **`dreamer.py`**: Serves as the main entry point of the program, implementing workflows such as training, sampling, and other essential processes.
- **`models.py`**: Implements the core training code.
- **`networks.py`**: Implements the corresponding CsRSSM structure in the `RSSM` class.

## Acknowledgments

We extend our gratitude to NM512 for their valuable open-source implementation [https://github.com/NM512/dreamerv3-torch](https://github.com/NM512/dreamerv3-torch).



