# Clusterability in Neural Networks
and
# Importance and Coherence: Methods for Evaluating Modularity in Neural Networks

## Results

See results folder


## Instructions

This requires the Imagenet2012 validation dataset. You will need to register at [http://www.image-net.org/download-images](http://www.image-net.org/download-images) and obtain a link to download the dataset. Then execute the following.
```bash
mkdir datasets
mkdir datasets/imagenet2012
cd datasets/imagenet2012
wget [YOUR LINK HERE]
```
That's all! When running experiments with imagenet models, tfrecords will be created automatically from the `.tar` file.

See `shells/prepare_all.sh` for commands to make datasets, train networks, cluster, perform visualization experiments, and perform lesion experiments. We use `make` with a `Makefile` to automate the project.

## Research Environment Setup

Requirements: Python 3.7 (It might work with an earlier version, but it wasn't tested)

The environment is set up in a Python virtual environment. To do so:

1. Clone this repository

2. Install `graphviz`
   1. Ubuntu/Debian: `apt intall graphviz`
   2. MacOS: `brew install graphviz`

3. Install with `pipenv install --dev`

4. On MacOS **only**, you will need to install `pygraphviz` separatly:
   `pipenv run pip install pygraphviz --install-option="--include-path=/usr/local/Cellar/`
   
5. To enter the virtual environment, type `pipenv shell`

6. To set up the dependencies and finish, type `cd nn_clustering` and `./build.sh`

One final note: in several parts of the repository, absolute paths are coded which start with `project/nn_clustering/`. This works for running things through a docker container, but for the purposes of review, instructions for the docker container are not included here. If needed, we recommend doing a project-wide find and replace for places in which these absolute paths are used. 
