#!/usr/bin/env bash

# datasets (also be sure to follow instructions in the README for imagenet)
bash shells/make_datasets.sh

# train
bash shells/train_mlps.sh
bash shells/train_cnns.sh
bash shells/train_cnn_vggs.sh
echo "Training MLPs with the clusterability gradient takes 20 hours on one of the author's laptops."
echo "Do you want to train MLPs with the clusterability gradient? [y,n]"
read doit
case $doit in
    y|Y) echo "I'll do it then" ; bash shells/train_clust_grad.sh ;;
    n|N) echo "Understood." ;;
    *) echo "I didn't understand that" ;;
esac

# clustering randomly initialized networks (produces results for the Clusterability in Neural Networks paper)
make random-init-ncuts

# clustering (produces results for the Clusterability in Neural Networks paper)
make clustering-factors-mlp
make clustering-factors-clust-grad
make clustering-factors-cnn
make clustering-factors-cnn-vgg
make clustering-factors-imagenet

# input construction with lucid (produces results for the Importance and Coherence paper)
make lucid-make-dataset-mlp
make lucid-make-dataset-cnn
make lucid-make-dataset-cnn-vgg
make lucid-prep-imagenet
make lucid-make-dataset-imagenet
make lucid-results-all

# lesion tests (produces results for the Importance and Coherence paper)
make lesion-results-mlp
make lesion-results-cnn
make lesion-results-cnn-vgg
make lesion-results-imagenet
make mlp-double-lesion

# produces key plots and images, including input correlation visualizations (produces results for both papers)
make plotting-main

