"""
Utility for configuring logging.
"""
import logging
import sys

def setup_logging(level=logging.INFO):
    """
    Configures the root logger for the project.

    This setup provides a consistent logging format and directs output
    to stdout.

    Args:
        level (int): The logging level, e.g., logging.INFO, logging.DEBUG.
    """
    log_format = (
        '%(asctime)s - %(levelname)s - [%(name)s:%(funcName)s:%(lineno)d] - %(message)s'
    )
    logging.basicConfig(
        level=level,
        format=log_format,
        handlers=[logging.StreamHandler(sys.stdout)]
    )
