# IterComp: Iterative Composition-Aware Feedback Learning from Model Gallery for Text-to-Image Generation


## Installation

```shell
conda create -n IterComp python==3.8.10
conda activate IterComp
pip install -r requirements.txt
```

## Build the Model Gallery

You should first build the model gallery, we provide the code for text-controlled methods(SD 1.5, SD2.1, SDXL, SD 3, FLUX) to build the model gallery:

```bash
python data/model_gallery.py 
```

We collect composition-aware model preference using this model gallery.

## Composition-Aware Reward Models Training

First, you should pair the images two by two based on the ranking:

```bash
python train/make_dataset.py
```

We provide a script for reward models training:

```bash
bash scripts/train_reward_models.sh
```

For each of the composition-aware reward models, you should follow this process to get the reward model.

## Multi-Reward Feedback Learning

The training dataset for multi-reward feedback learning is in `data/itercomp_train_data.json`, after setting the pathes for composition-aware reward models, you can finetune the base diffusion model as follow:

```shell
bash scripts/iterative_fl.sh
```

## Iterative Feedback Learning

After the training of iteration 0, we can start a new iteration of refinement based on the optimized diffusion model. 

In iteration 1, we expand model gallery with omost and the optimized base diffusion model using:

```bash
python data/iterative_expand_gallery.py
```

After updating the composition-aware model preference dataset, you should to train the reward models and base diffusion model according to the process described above.

