# run a synthetic experiment
#

using JLD2;
using Distributed;

@everywhere include("runit.jl")


# setup bandit problem

B = 4.5;  # second-moment constraint
θ = 0.6; # quantile for CVaR
ϵ = 0.7; 


dist1=MixtureModel([GeneralizedExtremeValue(-1, 1/2,  .4),
                      GeneralizedExtremeValue(-3, 1/2, -.4)]);
dist2=GeneralizedPareto(2.25,0.1,0.01);
#dist3=GeneralizedExtremeValue(-1/2, 2/2, 1/10);

# Arm characteristics:
# dist1 : (1.7th)-moment 4.0148, c_0.6(arm1) -0.1428
# dist2 : (1.7th)-moment 4.28169, c_0.6(dist3) 2.44399
# dist3 : (1.7th)-moment 1.6868, c_0.6(arm2) 1.5474

global MAB = (dist1, );


δs = (0.05,);
βs = GK16.(δs);


if length(ARGS) > 1
    filepath = ARGS[1];
    N, fromArms, toArms = parse.(Int64, (ARGS[2], ARGS[3], ARGS[4]))
    myrange = 1:N
else
    filepath = ARGS[1];
    N=1000;
    fromArms=2; toArms=21; myrange = 1:N;
end

seed = 1932; # repeatability

while length(MAB) < fromArms-1
    global MAB = (MAB ..., dist2);
end

for j in fromArms:toArms  
    global MAB = (MAB ..., dist2);
    @assert length(MAB) == j "Number of arms:$length(MAB), round:$j"
    
    # compute in parallel
    @time data = pmap(i -> runit(seed+i+j*N, MAB, βs, B, θ, ϵ), 1:N);

    # save
    @save string(filepath,"experiment",j,".dat") B θ ϵ MAB δs βs myrange seed data j
end