using JLD2;
using Plots;
#using LinearAlgebra;

include("experiment_helpers.jl")

δs =[];

global x=[];
global y1=[];
global y2=[];
global y3=[];

global a = [];

filepath = isempty(ARGS) ? "output/" : ARGS[1];
if length(ARGS) > 0
    fromSeed, toSeed = parse.(Int64, (ARGS[2], ARGS[3]));
    global a = [fromSeed:1000:toSeed ...];
else
    #a = [7.5:0.5:13.5 ..., 15.5, 19];
    a=[7.5:0.5:25 ...]
end


for i in a
    #filename05 = string(filepath,"data/05/0_5varBexperiment",i,".dat");
    #filename07 = string(filepath,"data/07/0_7varBexperiment",i,".dat");
    filename11 = string(filepath,"data/11/1_1varBexperiment",i,".dat");
    
    #@load filename05 B θ ϵ MAB δs βs myrange seed data;
    #B1=B; data1=data;
    #@load filename07 B θ ϵ MAB δs βs myrange seed data;
    #B2=B; data2=data;
    
    @load filename11 B θ ϵ MAB δs βs myrange seed data;
    B3=B; data3=data;
    
    #@assert i == B1 && i==B2 && i==B3 "in $i iteration, got $B1 $B2 $B3"
    
    N=length(myrange);
    
    #sc1 = sum(sum.(getindex.(getindex.(data1, 1),2)))/length(sum.(getindex.(getindex.(data, 1),2)))
    #sc2 = sum(sum.(getindex.(getindex.(data2, 1),2)))/length(sum.(getindex.(getindex.(data, 1),2)))
    sc3 = sum(sum.(getindex.(getindex.(data3, 1),2)))/length(sum.(getindex.(getindex.(data, 1),2))) 
    
    global x= [x..., B];
    #global y1= [y1 ..., sc1];
    #global y2= [y2 ..., sc2];
    global y3= [y3 ..., sc3];
end

#y = [y1, y2, y3];

#p=plot(x,y,fmt = :pdf, legendtitle="ϵ", label=["0.5" "0.7" "1.1"], title = string("Empirical Sample Complexity vs moment bound"), xlabel="B", ylabel="Avg. stopping time",legend=:topleft, lw=2, left_margin=7Plots.mm, bottom_margin=5Plots.mm);

p=plot(x,y3,fmt = :pdf, legendtitle="ϵ", label="1.1", title = string("Empirical Sample Complexity vs moment bound"), xlabel="B", ylabel="Avg. stopping time",legend=:topleft, lw=2, left_margin=7Plots.mm, bottom_margin=5Plots.mm);

savefig(p, string(filepath,"plots/sc_VB.pdf"));
