# bandit (i.e. zeroth order i.e. value oracle based) minimisation for strictly quasiconvex function
function ϕsect(f, lo, hi; maxiter = 32)
    # solution to ϕ^2 = 1-ϕ, This is the proportion of
    # the range eliminated each iteration
    ϕ = (sqrt(5)-1)/2;

    m = (1-ϕ)*lo+ϕ*hi;
    v = f(m);
    # invariant: v is f at m = (1-ϕ)*lo+ϕ*hi, which is toward hi

    for i = 1:maxiter
        @assert m ≈ (1-ϕ)*lo+ϕ*hi "$i: $(m) vs $((1-ϕ)*lo+ϕ*hi)";
        m2 = (1-ϕ)*lo + ϕ*m;

        #@assert (hi-m)*(m-lo) > 0;

        v2 = f(m2); # between lo and previous evaluation point

        #@assert v != v2; # plateaus. What can one do but scan all?
        v, lo, m, hi = if v2 < v
            v2, lo, m2, m
        else
            v, hi, m, m2; # this reverses the range
        end
    end
    v, m;
end
