using JLD2;
using Plots;
using Distributions; 

include("experiment_helpers.jl")

filepath = isempty(ARGS) ? "output/" : ARGS[1];
filename = string(filepath,"experiment.dat");

@load filename B θ ϵ MAB δs βs myrange seed data


N=length(myrange);
# canonicalise the display in CVaR order
ix = sortperm([cvar.(MAB, θ)...])

⋆, D, w = crack(MAB[ix], B, θ, ϵ)
table_dump(MAB[ix], B, θ, ⋆, D, w, δs, βs)
mkplot(MAB[ix], B, θ, ⋆, D, w, δs, βs, reorder(data, ix))
p = mkplot(MAB[ix], B, θ, ⋆, D, w, δs, βs, reorder(data, ix))
q = viz_mab_joint(MAB[ix])

savefig(p, string(filepath,"sample_complexity.pdf"))
savefig(q, string(filepath,"mab.pdf"))
